/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class SplitByTypeAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || !ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ServiceView selectedView = ServiceViewActionProvider.getSelectedView(e);
        if (selectedView == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).isSplitByTypeEnabled(selectedView);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ServiceView selectedView = ServiceViewActionProvider.getSelectedView(e);
        if (selectedView == null) {
            return;
        }
        ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).splitByType(selectedView);
    }
}

