/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

class ServiceViewTreeModel
extends BaseTreeModel<Object>
implements InvokerSupplier {
    private final ServiceViewModel myModel;
    private final Object myRoot = ObjectUtils.sentinel((String)"services root");

    ServiceViewTreeModel(@NotNull ServiceViewModel model) {
        this.myModel = model;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        return this.myModel.getInvoker();
    }

    public void dispose() {
    }

    @Override
    public boolean isLeaf(Object object) {
        ServiceModel.ServiceNode node;
        if (object == this.myRoot) {
            return false;
        }
        if (object instanceof ServiceModel.ServiceNode && !(node = (ServiceModel.ServiceNode)object).isChildrenInitialized() && !node.isLoaded()) {
            return false;
        }
        return this.myModel.getChildren((ServiceModel.ServiceViewItem)object).isEmpty();
    }

    @Override
    public List<?> getChildren(Object parent) {
        if (parent == this.myRoot) {
            this.myModel.initRootsIfNeeded();
            return this.myModel.getVisibleRoots();
        }
        return this.myModel.getChildren((ServiceModel.ServiceViewItem)parent);
    }

    public Object getRoot() {
        return this.myRoot;
    }

    void rootsChanged() {
        this.treeStructureChanged(new TreePath(this.myRoot), null, null);
    }

    Promise<TreePath> findPath(@NotNull Object service, @NotNull Class<?> contributorClass) {
        AsyncPromise result2 = new AsyncPromise();
        this.getInvoker().invoke(() -> {
            List<? extends ServiceModel.ServiceViewItem> roots = this.myModel.getVisibleRoots();
            ServiceModel.ServiceViewItem serviceNode = (ServiceModel.ServiceViewItem)((JBTreeTraverser)JBTreeTraverser.from(node -> contributorClass.isInstance(node.getRootContributor()) ? new ArrayList<ServiceModel.ServiceViewItem>(this.myModel.getChildren((ServiceModel.ServiceViewItem)node)) : null).withRoots(roots)).traverse(ServiceModel.NOT_LOADED_LAST_BFS).filter(node -> node.getValue().equals(service)).first();
            if (serviceNode != null) {
                ArrayList<Object> path = new ArrayList<Object>();
                do {
                    path.add(serviceNode);
                } while ((serviceNode = roots.contains(serviceNode) ? null : serviceNode.getParent()) != null);
                path.add(this.myRoot);
                Collections.reverse(path);
                result2.setResult((Object)new TreePath(ArrayUtil.toObjectArray(path)));
                return;
            }
            result2.setError("Service not found");
        });
        return result2;
    }
}

