/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceModelFilter {
    private final List<ServiceViewFilter> myFilters = new CopyOnWriteArrayList<ServiceViewFilter>();

    ServiceModelFilter() {
    }

    void addFilter(@NotNull ServiceViewFilter filter2) {
        this.myFilters.add(filter2);
    }

    void removeFilter(@NotNull ServiceViewFilter filter2) {
        ServiceViewFilter parent = filter2.getParent();
        this.myFilters.remove(filter2);
        for (ServiceViewFilter viewFilter : this.myFilters) {
            if (viewFilter.getParent() != filter2) continue;
            viewFilter.setParent(parent);
        }
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> filter(@NotNull List<? extends ServiceModel.ServiceViewItem> items, @NotNull ServiceViewFilter targetFilter) {
        if (items.isEmpty()) {
            return items;
        }
        List<ServiceViewFilter> filters = this.excludeTargetAndParents(targetFilter);
        return ContainerUtil.filter(items, item -> filters.stream().noneMatch(filter2 -> filter2.value(item)));
    }

    private List<ServiceViewFilter> excludeTargetAndParents(@NotNull ServiceViewFilter targetFilter) {
        ArrayList<ServiceViewFilter> filters = new ArrayList<ServiceViewFilter>(this.myFilters);
        do {
            filters.remove(targetFilter);
        } while ((targetFilter = targetFilter.getParent()) != null);
        return filters;
    }

    static abstract class ServiceViewFilter
    implements Condition<ServiceModel.ServiceViewItem> {
        private ServiceViewFilter myParent;

        protected ServiceViewFilter(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }

        @Nullable
        ServiceViewFilter getParent() {
            return this.myParent;
        }

        private void setParent(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }
    }
}

