/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRerunAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        ExecutionEnvironment environment = this.getEnvironment(event);
        if (environment != null) {
            presentation2.setText(ExecutionBundle.messagePointer((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)environment.getRunProfile().getName())}));
            presentation2.setIcon("TouchBarGeneral".equals(event.getPlace()) || ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event)) ? AllIcons.Actions.Restart : environment.getExecutor().getIcon());
            presentation2.setEnabled(this.isEnabled(event));
            return;
        }
        presentation2.setEnabled(false);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment = this.getEnvironment(event);
        if (environment != null) {
            MacroManager.getInstance().cacheMacrosPreview(event.getDataContext());
            ExecutionUtil.restart((ExecutionEnvironment)environment);
        }
    }

    @Nullable
    protected RunContentDescriptor getDescriptor(AnActionEvent event) {
        return (RunContentDescriptor)event.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
    }

    @Nullable
    protected ExecutionEnvironment getEnvironment(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment = (ExecutionEnvironment)event.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
        if (environment == null) {
            JComponent component2;
            RunContentDescriptor contentDescriptor;
            Project project = event.getProject();
            RunContentManager runContentManager = project == null ? null : RunContentManager.getInstanceIfCreated((Project)project);
            RunContentDescriptor runContentDescriptor = contentDescriptor = runContentManager == null ? null : runContentManager.getSelectedContent();
            if (contentDescriptor != null && (component2 = contentDescriptor.getComponent()) != null) {
                environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component2));
            }
        }
        return environment;
    }

    protected boolean isEnabled(AnActionEvent event) {
        RunContentDescriptor descriptor2 = this.getDescriptor(event);
        ProcessHandler processHandler2 = descriptor2 == null ? null : descriptor2.getProcessHandler();
        ExecutionEnvironment environment = this.getEnvironment(event);
        Project project = FakeRerunAction.getEventProject((AnActionEvent)event);
        if (environment == null || project == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        return !(DumbService.isDumb((Project)project) && settings != null && !settings.getType().isDumbAware() || ExecutionManager.getInstance((Project)project).isStarting(environment) || processHandler2 != null && processHandler2.isProcessTerminating());
    }

    public boolean isDumbAware() {
        return true;
    }
}

