/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteProcess;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillableProcessHandler
extends OSProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableProcessHandler.class);
    private static final Key<Boolean> MEDIATOR_KEY = Key.create((String)"KillableProcessHandler.Mediator.Process");
    private boolean myShouldKillProcessSoftly = true;
    private final boolean myMediatedProcess;
    private boolean myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is((String)"use.winp.for.graceful.process.termination");

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
        this.myMediatedProcess = MEDIATOR_KEY.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        this(KillableProcessHandler.mediate(commandLine, withMediator, false));
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine) {
        super(process2, commandLine);
        this.myMediatedProcess = false;
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        this(process2, commandLine, charset, null);
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset, @Nullable Set<? extends File> filesToDelete) {
        super(process2, commandLine, charset, filesToDelete);
        this.myMediatedProcess = false;
    }

    @NotNull
    protected static GeneralCommandLine mediate(@NotNull GeneralCommandLine commandLine, boolean withMediator, boolean showConsole) {
        if (withMediator && SystemInfo.isWindows && MEDIATOR_KEY.get((UserDataHolder)commandLine) == null) {
            boolean mediatorInjected = RunnerMediator.injectRunnerCommand(commandLine, showConsole);
            MEDIATOR_KEY.set((UserDataHolder)commandLine, (Object)mediatorInjected);
        }
        return commandLine;
    }

    public boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    private boolean canKillProcessSoftly() {
        if (KillableProcessHandler.processCanBeKilledByOS((Process)this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.myMediatedProcess || this.myShouldKillProcessSoftlyWithWinP;
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void notifyProcessTerminated(int exitCode) {
        try {
            super.closeStreams();
        }
        finally {
            super.notifyProcessTerminated(exitCode);
        }
    }

    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted;
        boolean bl = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canKillProcessSoftly() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    @ApiStatus.Experimental
    public void setShouldKillProcessSoftlyWithWinP(boolean shouldKillProcessSoftlyWithWinP) {
        this.myShouldKillProcessSoftlyWithWinP = shouldKillProcessSoftlyWithWinP;
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows) {
            if (this.myMediatedProcess) {
                return RunnerMediator.destroyProcess(this.myProcess, true);
            }
            if (this.myShouldKillProcessSoftlyWithWinP && !Registry.is((String)"disable.winp")) {
                try {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess((Process)this.myProcess, (String)"destroy", (String)this.getCommandLine());
                        return true;
                    }
                    return OSProcessUtil.createWinProcess((Process)this.myProcess).sendCtrlC();
                }
                catch (Throwable e) {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess((Process)this.myProcess, (String)"destroy", (String)this.getCommandLine());
                        return true;
                    }
                    LOG.error("Failed to send Ctrl+C, fallback to default termination: " + this.getCommandLine(), e);
                }
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigIntToProcessTree((Process)this.myProcess);
        }
        return false;
    }

    @Override
    public boolean canKillProcess() {
        return KillableProcessHandler.processCanBeKilledByOS((Process)this.getProcess()) || this.getProcess() instanceof RemoteProcess;
    }

    @Override
    public void killProcess() {
        if (KillableProcessHandler.processCanBeKilledByOS((Process)this.getProcess())) {
            this.killProcessTree(this.getProcess());
        } else if (this.getProcess() instanceof RemoteProcess) {
            ((RemoteProcess)this.getProcess()).killProcessTree();
        }
    }
}

