/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Comparator<RunLineMarkerContributor.Info> COMPARATOR = (a, b) -> {
        if (b.shouldReplace((RunLineMarkerContributor.Info)a)) {
            return 1;
        }
        if (a.shouldReplace((RunLineMarkerContributor.Info)b)) {
            return -1;
        }
        return 0;
    };
    private static final Key<Boolean> HAS_ANYTHING_RUNNABLE = Key.create((String)"HAS_ANYTHING_RUNNABLE");

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element2) {
        RunLineMarkerContributor.Info info2;
        List contributors = RunLineMarkerContributor.EXTENSION.allForLanguageOrAny(element2.getLanguage());
        Icon icon2 = null;
        List infos = null;
        for (RunLineMarkerContributor contributor : contributors) {
            info2 = contributor.getInfo(element2);
            if (info2 == null) continue;
            if (icon2 == null) {
                icon2 = info2.icon;
            }
            if (infos == null) {
                infos = new SmartList();
            }
            infos.add(info2);
        }
        if (icon2 == null) {
            return null;
        }
        if (infos.size() > 1) {
            infos.sort(COMPARATOR);
            RunLineMarkerContributor.Info first = (RunLineMarkerContributor.Info)infos.get(0);
            Iterator it = infos.iterator();
            while (it.hasNext()) {
                info2 = (RunLineMarkerContributor.Info)it.next();
                if (info2 == first || !first.shouldReplace(info2)) continue;
                it.remove();
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info2 : infos) {
            for (AnAction action2 : info2.actions) {
                actionGroup.add((AnAction)new LineMarkerActionWrapper(element2, action2));
            }
            if (info2 == infos.get(infos.size() - 1)) continue;
            actionGroup.add((AnAction)new Separator());
        }
        List finalInfos = infos;
        Function tooltipProvider = element1 -> {
            StringBuilder tooltip = new StringBuilder();
            for (RunLineMarkerContributor.Info info : finalInfos) {
                String string;
                if (info.tooltipProvider == null || (string = info.tooltipProvider.apply((PsiElement)element1)) == null) continue;
                if (tooltip.length() != 0) {
                    tooltip.append("\n");
                }
                tooltip.append(string);
            }
            return tooltip.length() == 0 ? null : tooltip.toString();
        };
        return new RunLineMarkerInfo(element2, icon2, (Function<PsiElement, String>)tooltipProvider, actionGroup);
    }

    @NotNull
    public String getName() {
        return ExecutionBundle.message((String)"run.line.marker.name", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    @NotNull
    public static ThreeState hadAnythingRunnable(@NotNull VirtualFile file2) {
        Boolean data2 = (Boolean)file2.getUserData(HAS_ANYTHING_RUNNABLE);
        return data2 == null ? ThreeState.UNSURE : ThreeState.fromBoolean((boolean)data2);
    }

    public static void markRunnable(@NotNull VirtualFile file2, boolean isRunnable) {
        file2.putUserData(HAS_ANYTHING_RUNNABLE, (Object)isRunnable);
    }

    static class RunLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final DefaultActionGroup myActionGroup;

        RunLineMarkerInfo(PsiElement element2, Icon icon2, Function<PsiElement, String> tooltipProvider, DefaultActionGroup actionGroup) {
            super(element2, element2.getTextRange(), icon2, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER);
            this.myActionGroup = actionGroup;
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }
            };
        }

        @NotNull
        public MarkupEditorFilter getEditorFilter() {
            return MarkupEditorFilterFactory.createIsNotDiffFilter();
        }
    }
}

