/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.statistics.RunConfigurationTypeUsagesCollector;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunConfigurationUsageTriggerCollector {
    @NotNull
    public static IdeActivity trigger(@NotNull Project project, @NotNull ConfigurationFactory factory2, @NotNull Executor executor) {
        ConfigurationType configurationType = factory2.getType();
        return new IdeActivity(project, "run.configuration.exec").startedWithData(data2 -> data2.addAll(RunConfigurationTypeUsagesCollector.newFeatureUsageData(configurationType, factory2).addData("executor", executor.getId())));
    }

    public static class RunConfigurationExecutorUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "run_config_executor".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)executor.getId(), (CharSequence)data2)) continue;
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(executor.getClass());
                return info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            }
            return ValidationResultType.REJECTED;
        }
    }
}

