/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.NotNull;

public class NameGeneratingListenerDecorator
implements RefactoringElementListener,
UndoRefactoringElementListener {
    private final LocatableConfiguration myConfiguration;
    private final RefactoringElementListener myListener;

    public NameGeneratingListenerDecorator(LocatableConfiguration configuration, RefactoringElementListener listener2) {
        this.myConfiguration = configuration;
        this.myListener = listener2;
    }

    public void elementMoved(@NotNull PsiElement newElement) {
        boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
        this.myListener.elementMoved(newElement);
        if (hasGeneratedName) {
            this.updateSuggestedName();
        }
    }

    public void elementRenamed(@NotNull PsiElement newElement) {
        boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
        this.myListener.elementRenamed(newElement);
        if (hasGeneratedName) {
            this.updateSuggestedName();
        }
    }

    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
        if (this.myListener instanceof UndoRefactoringElementListener) {
            boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
            ((UndoRefactoringElementListener)this.myListener).undoElementMovedOrRenamed(newElement, oldQualifiedName);
            if (hasGeneratedName) {
                this.updateSuggestedName();
            }
        }
    }

    private void updateSuggestedName() {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myConfiguration.getProject());
        this.myConfiguration.setName(this.myConfiguration.suggestedName());
        RunnerAndConfigurationSettingsImpl settings = runManager.getSettings((RunConfiguration)this.myConfiguration);
        if (settings != null) {
            runManager.addConfiguration(settings);
        }
    }
}

