/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.statistics.RunConfigurationUsageTriggerCollector;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.UIBundle;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a \u0010\u001a\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"EMPTY_PROCESS_HANDLERS", "", "Lcom/intellij/execution/process/ProcessHandler;", "[Lcom/intellij/execution/process/ProcessHandler;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createEnvironmentBuilder", "Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Lcom/intellij/execution/Executor;", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "triggerUsage", "Lcom/intellij/internal/statistic/IdeActivity;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "userApprovesStopForIncompatibleConfigurations", "", "configName", "", "runningIncompatibleDescriptors", "", "Lcom/intellij/execution/ui/RunContentDescriptor;", "userApprovesStopForSameTypeConfigurations", "instancesCount", "", "intellij.platform.execution.impl"})
public final class ExecutionManagerImplKt {
    private static final Logger LOG;
    private static final ProcessHandler[] EMPTY_PROCESS_HANDLERS;

    private static final IdeActivity triggerUsage(ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings == null || (runnerAndConfigurationSettings = runnerAndConfigurationSettings.getConfiguration()) == null || (runnerAndConfigurationSettings = runnerAndConfigurationSettings.getFactory()) == null) {
            return null;
        }
        RunnerAndConfigurationSettings configurationFactory = runnerAndConfigurationSettings;
        return RunConfigurationUsageTriggerCollector.trigger(environment.getProject(), (ConfigurationFactory)configurationFactory, environment.getExecutor());
    }

    private static final ExecutionEnvironmentBuilder createEnvironmentBuilder(Project project, Executor executor, RunnerAndConfigurationSettings configuration) {
        ProgramRunner runner;
        ProgramRunner programRunner;
        ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(project, executor);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = configuration;
        if (runnerAndConfigurationSettings != null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            boolean bl = false;
            boolean bl2 = false;
            RunnerAndConfigurationSettings it = runnerAndConfigurationSettings2;
            boolean bl3 = false;
            programRunner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)it.getConfiguration()));
        } else {
            programRunner = runner = null;
        }
        if (runner == null && configuration != null) {
            LOG.error("Cannot find runner for " + configuration.getName());
        } else if (runner != null) {
            builder2.runnerAndSettings(runner, configuration);
        }
        return builder2;
    }

    private static final boolean userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        RunManagerConfig config2 = RunManagerImpl.Companion.getInstanceImpl(project).getConfig();
        if (!config2.isRestartRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(config2){
            final /* synthetic */ RunManagerConfig $config;

            public boolean isToBeShown() {
                return this.$config.isRestartRequiresConfirmation();
            }

            public void setToBeShown(boolean value2, int exitCode) {
                this.$config.setRestartRequiresConfirmation(value2);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                return UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
            {
                this.$config = $captured_local_variable$0;
            }
        };
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"rerun.singleton.confirmation.message", (Object[])new Object[]{configName, instancesCount}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{configName}), (String)ExecutionBundle.message((String)"rerun.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option2) == 0;
    }

    private static final boolean userApprovesStopForIncompatibleConfigurations(Project project, String configName, List<? extends RunContentDescriptor> runningIncompatibleDescriptors) {
        RunManagerConfig config2 = RunManagerImpl.Companion.getInstanceImpl(project).getConfig();
        if (!config2.isStopIncompatibleRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(config2){
            final /* synthetic */ RunManagerConfig $config;

            public boolean isToBeShown() {
                return this.$config.isStopIncompatibleRequiresConfirmation();
            }

            public void setToBeShown(boolean value2, int exitCode) {
                this.$config.setStopIncompatibleRequiresConfirmation(value2);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                return UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
            {
                this.$config = $captured_local_variable$0;
            }
        };
        StringBuilder names2 = new StringBuilder();
        for (RunContentDescriptor runContentDescriptor : runningIncompatibleDescriptors) {
            String string;
            String name = runContentDescriptor.getDisplayName();
            CharSequence charSequence = names2;
            boolean bl = false;
            if (charSequence.length() > 0) {
                names2.append(", ");
            }
            charSequence = name;
            bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                string = ExecutionBundle.message((String)"run.configuration.no.name", (Object[])new Object[0]);
            } else {
                charSequence = StringCompanionObject.INSTANCE;
                String string2 = "'%s'";
                Object[] objectArray = new Object[]{name};
                boolean bl3 = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            }
            names2.append(string);
        }
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.message", (Object[])new Object[]{configName, names2.toString(), runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"incompatible.configuration.is.running.dialog.title", (Object[])new Object[]{runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option2) == 0;
    }

    static {
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(ExecutionManagerImpl.class);
        EMPTY_PROCESS_HANDLERS = new ProcessHandler[0];
    }

    public static final /* synthetic */ IdeActivity access$triggerUsage(ExecutionEnvironment environment) {
        return ExecutionManagerImplKt.triggerUsage(environment);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ProcessHandler[] access$getEMPTY_PROCESS_HANDLERS$p() {
        return EMPTY_PROCESS_HANDLERS;
    }

    public static final /* synthetic */ ExecutionEnvironmentBuilder access$createEnvironmentBuilder(Project project, Executor executor, RunnerAndConfigurationSettings configuration) {
        return ExecutionManagerImplKt.createEnvironmentBuilder(project, executor, configuration);
    }

    public static final /* synthetic */ boolean access$userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        return ExecutionManagerImplKt.userApprovesStopForSameTypeConfigurations(project, configName, instancesCount);
    }

    public static final /* synthetic */ boolean access$userApprovesStopForIncompatibleConfigurations(Project project, String configName, List runningIncompatibleDescriptors) {
        return ExecutionManagerImplKt.userApprovesStopForIncompatibleConfigurations(project, configName, runningIncompatibleDescriptors);
    }
}

