/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.DynamicBundle;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.impl.BeforeRunStepsPanel;
import com.intellij.execution.impl.ConfigurationSettingsEditor;
import com.intellij.execution.impl.RunConfigurationCreator;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunConfigurationFragmentedEditor;
import com.intellij.execution.ui.RunnerAndConfigurationSettingsEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConfigurationSettingsEditorWrapper
extends SettingsEditor<RunnerAndConfigurationSettings>
implements BeforeRunStepsPanel.StepsBeforeRunListener {
    public static final DataKey<ConfigurationSettingsEditorWrapper> CONFIGURATION_EDITOR_KEY = DataKey.create((String)"ConfigurationSettingsEditor");
    @NonNls
    private static final String EXPAND_PROPERTY_KEY = "ExpandBeforeRunStepsPanel";
    private JPanel myComponentPlace;
    private JPanel myWholePanel;
    private JPanel myBeforeLaunchContainer;
    private JBCheckBox myIsAllowRunningInParallelCheckBox;
    private JPanel myDisclaimerPanel;
    private JLabel myDisclaimerLabel;
    private JLabel myCreateNewRCLabel;
    private final BeforeRunStepsPanel myBeforeRunStepsPanel;
    private final ConfigurationSettingsEditor myEditor;
    private final HideableDecorator myDecorator;

    public <T extends SettingsEditor> T selectExecutorAndGetEditor(ProgramRunner runner, Class<T> editorClass) {
        return this.myEditor.selectExecutorAndGetEditor(runner, editorClass);
    }

    public <T extends SettingsEditor> T selectTabAndGetEditor(Class<T> editorClass) {
        return this.myEditor.selectTabAndGetEditor(editorClass);
    }

    private ConfigurationSettingsEditorWrapper(@NotNull RunnerAndConfigurationSettings settings, SettingsEditor<RunConfiguration> configurationEditor) {
        this.$$$setupUI$$$();
        this.myEditor = new ConfigurationSettingsEditor(settings, configurationEditor);
        this.myEditor.addSettingsEditorListener(editor -> this.fireStepsBeforeRunChanged());
        Disposer.register((Disposable)this, (Disposable)this.myEditor);
        this.myBeforeRunStepsPanel = new BeforeRunStepsPanel(this);
        this.myDecorator = new HideableDecorator(this.myBeforeLaunchContainer, "", false){

            @Override
            protected void on() {
                super.on();
                this.storeState();
            }

            @Override
            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue(ConfigurationSettingsEditorWrapper.EXPAND_PROPERTY_KEY, String.valueOf(this.isExpanded()));
            }
        };
        this.myDecorator.setOn(PropertiesComponent.getInstance().getBoolean(EXPAND_PROPERTY_KEY, true));
        this.myDecorator.setContentComponent(this.myBeforeRunStepsPanel);
        this.doReset(settings);
    }

    private void doReset(@NotNull RunnerAndConfigurationSettings settings) {
        this.myBeforeRunStepsPanel.doReset(settings);
        this.myBeforeLaunchContainer.setVisible(!(settings.getConfiguration() instanceof WithoutOwnBeforeRunSteps));
        this.myIsAllowRunningInParallelCheckBox.setSelected(settings.getConfiguration().isAllowRunningInParallel());
        this.myIsAllowRunningInParallelCheckBox.setVisible(settings.isTemplate() && settings.getFactory().getSingletonPolicy().isPolicyConfigurable());
        this.myDisclaimerPanel.setVisible(settings.isTemplate() && ProjectManager.getInstance().getOpenProjects().length != 0);
    }

    @NotNull
    protected JComponent createEditor() {
        this.myComponentPlace.setLayout(new BorderLayout());
        this.myComponentPlace.add((Component)this.myEditor.getComponent(), "Center");
        DataManager.registerDataProvider((JComponent)this.myWholePanel, dataId -> {
            if (CONFIGURATION_EDITOR_KEY.is(dataId)) {
                return this;
            }
            return null;
        });
        return this.myWholePanel;
    }

    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettings settings) {
        this.myEditor.resetEditorFrom(settings);
        this.doReset(settings);
    }

    public void applyEditorTo(@NotNull RunnerAndConfigurationSettings settings) throws ConfigurationException {
        this.myEditor.applyEditorTo(settings);
        this.doApply((RunnerAndConfigurationSettingsImpl)settings, false);
    }

    @NotNull
    public RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings result2 = this.myEditor.getSnapshot();
        this.doApply((RunnerAndConfigurationSettingsImpl)result2, true);
        return result2;
    }

    private void doApply(@NotNull RunnerAndConfigurationSettingsImpl settings, boolean isSnapshot) {
        RunConfiguration runConfiguration = settings.getConfiguration();
        List tasks = ContainerUtil.copyList(this.myBeforeRunStepsPanel.getTasks());
        RunnerAndConfigurationSettingsImpl settingsToApply = null;
        if (isSnapshot) {
            runConfiguration.setBeforeRunTasks(tasks);
        } else {
            RunManagerImpl runManager = settings.getManager();
            runManager.setBeforeRunTasks(runConfiguration, tasks);
            settingsToApply = runManager.getSettings(runConfiguration);
        }
        if (settingsToApply == null) {
            settingsToApply = settings;
        }
        settingsToApply.setEditBeforeRun(this.myBeforeRunStepsPanel.needEditBeforeRun());
        settingsToApply.setActivateToolWindowBeforeRun(this.myBeforeRunStepsPanel.needActivateToolWindowBeforeRun());
        if (this.myIsAllowRunningInParallelCheckBox.isVisible()) {
            settings.getConfiguration().setAllowRunningInParallel(this.myIsAllowRunningInParallelCheckBox.isSelected());
        }
    }

    public void addBeforeLaunchStep(@NotNull BeforeRunTask<?> task2) {
        this.myBeforeRunStepsPanel.addTask(task2);
    }

    @NotNull
    public List<BeforeRunTask<?>> getStepsBeforeLaunch() {
        return this.myBeforeRunStepsPanel.getTasks();
    }

    @Override
    public void fireStepsBeforeRunChanged() {
        this.fireEditorStateChanged();
    }

    @Override
    public void titleChanged(@NotNull String title) {
        this.myDecorator.setTitle(title);
    }

    private void createUIComponents() {
        this.myDisclaimerLabel = new JLabel(ExecutionBundle.message((String)"template.disclaimer", (Object[])new Object[0]), AllIcons.General.Warning, 10);
        this.myDisclaimerLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)2));
        this.myCreateNewRCLabel = new LinkLabel(ExecutionBundle.message((String)"create.configuration", (Object[])new Object[0]), null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                RunConfigurationCreator creator = (RunConfigurationCreator)DataManager.getInstance().getDataContext((Component)ConfigurationSettingsEditorWrapper.this.myDisclaimerLabel).getData(RunConfigurationCreator.KEY);
                if (creator != null) {
                    creator.createNewConfiguration(((RunnerAndConfigurationSettings)ConfigurationSettingsEditorWrapper.this.myEditor.getFactory().create()).getFactory());
                }
            }
        });
    }

    public static SettingsEditor<RunnerAndConfigurationSettings> createWrapper(@NotNull RunnerAndConfigurationSettings settings) {
        SettingsEditor configurationEditor = settings.getConfiguration().getConfigurationEditor();
        return configurationEditor instanceof RunConfigurationFragmentedEditor ? new RunnerAndConfigurationSettingsEditor(settings, (RunConfigurationFragmentedEditor)configurationEditor) : new ConfigurationSettingsEditorWrapper(settings, (SettingsEditor<RunConfiguration>)configurationEditor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myWholePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myComponentPlace = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBeforeLaunchContainer = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 0, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIsAllowRunningInParallelCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", ConfigurationSettingsEditorWrapper.class).getString("run.configuration.allow.running.parallel"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myDisclaimerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), 5, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = this.myDisclaimerLabel;
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ExecutionBundle", ConfigurationSettingsEditorWrapper.class).getString("template.disclaimer"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 9, 0, 2, 0, null, null, null));
        JLabel jLabel2 = this.myCreateNewRCLabel;
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ExecutionBundle", ConfigurationSettingsEditorWrapper.class).getString("create.configuration"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 1, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

