/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseRCSettingsConfigurable
extends SettingsEditorConfigurable<RunnerAndConfigurationSettings> {
    BaseRCSettingsConfigurable(@NotNull SettingsEditor<RunnerAndConfigurationSettings> editor, @NotNull RunnerAndConfigurationSettings settings) {
        super(editor, (Object)settings);
    }

    public boolean isModified() {
        try {
            RunnerAndConfigurationSettings original = (RunnerAndConfigurationSettings)this.getSettings();
            RunManagerImpl runManager = ((RunnerAndConfigurationSettingsImpl)original).getManager();
            if (!original.isTemplate() && !runManager.hasSettings(original)) {
                return true;
            }
            if (!super.isModified()) {
                return false;
            }
            RunnerAndConfigurationSettings snapshot = (RunnerAndConfigurationSettings)this.getEditor().getSnapshot();
            if (this.isSpecificallyModified() || !RunManagerImplKt.doGetBeforeRunTasks(original.getConfiguration()).equals(RunManagerImplKt.doGetBeforeRunTasks(snapshot.getConfiguration()))) {
                return true;
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        return super.isModified();
    }

    boolean isSpecificallyModified() {
        return false;
    }

    public JComponent createComponent() {
        return BaseRCSettingsConfigurable.wrapWithScrollPane(super.createComponent());
    }

    @NotNull
    protected static JBScrollPane wrapWithScrollPane(@Nullable JComponent component2) {
        JBScrollPane scrollPane = new JBScrollPane(20, 31){

            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                JViewport viewport = this.getViewport();
                if (viewport != null) {
                    Component view = viewport.getView();
                    if (view instanceof Scrollable) {
                        d.width = ((Scrollable)((Object)view)).getPreferredScrollableViewportSize().width;
                    }
                    if (view != null) {
                        d.width = view.getMinimumSize().width;
                    }
                }
                d.height = Math.max(d.height, JBUIScale.scale((int)400));
                return d;
            }
        };
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        if (component2 != null) {
            scrollPane.getViewport().setView(component2);
        }
        return scrollPane;
    }
}

