/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

class AsyncFilterRunner {
    private static final Logger LOG = Logger.getInstance(AsyncFilterRunner.class);
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Console Filters");
    private final EditorHyperlinkSupport myHyperlinks;
    private final Editor myEditor;
    private final Queue<HighlighterJob> myQueue = new ConcurrentLinkedQueue<HighlighterJob>();
    @NotNull
    private List<FilterResult> myResults = new ArrayList<FilterResult>();

    AsyncFilterRunner(@NotNull EditorHyperlinkSupport hyperlinks, @NotNull Editor editor) {
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor;
    }

    void highlightHyperlinks(@NotNull Project project, @NotNull Filter customFilter, int startLine, int endLine) {
        if (endLine < 0) {
            return;
        }
        this.myQueue.offer(new HighlighterJob(project, customFilter, startLine, endLine, this.myEditor.getDocument()));
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.runTasks();
            this.highlightAvailableResults();
            return;
        }
        CancellablePromise promise = ReadAction.nonBlocking(this::runTasks).submit((Executor)ourExecutor);
        if (AsyncFilterRunner.isQuick(promise)) {
            this.highlightAvailableResults();
        } else {
            promise.onSuccess(__ -> {
                if (this.hasResults()) {
                    ApplicationManager.getApplication().invokeLater(this::highlightAvailableResults, ModalityState.any());
                }
            });
        }
    }

    private static boolean isQuick(Promise<?> future2) {
        try {
            future2.blockingGet(5, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void highlightAvailableResults() {
        for (FilterResult result2 : this.takeAvailableResults()) {
            result2.applyHighlights();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResults() {
        Queue<HighlighterJob> queue = this.myQueue;
        synchronized (queue) {
            return !this.myResults.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<FilterResult> takeAvailableResults() {
        Queue<HighlighterJob> queue = this.myQueue;
        synchronized (queue) {
            List<FilterResult> results = this.myResults;
            this.myResults = new ArrayList<FilterResult>();
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLineResult(@Nullable FilterResult result2) {
        if (result2 == null) {
            return;
        }
        Queue<HighlighterJob> queue = this.myQueue;
        synchronized (queue) {
            this.myResults.add(result2);
        }
    }

    boolean waitForPendingFilters(long timeoutMs) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        long started = System.currentTimeMillis();
        while (true) {
            if (this.myQueue.isEmpty()) {
                this.highlightAvailableResults();
                return true;
            }
            if (this.hasResults()) {
                this.highlightAvailableResults();
                continue;
            }
            if (System.currentTimeMillis() - started > timeoutMs) {
                return false;
            }
            TimeoutUtil.sleep((long)1L);
        }
    }

    private void runTasks() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myEditor.isDisposed()) {
            return;
        }
        while (!this.myQueue.isEmpty()) {
            HighlighterJob highlighter = this.myQueue.peek();
            if (!DumbService.isDumbAware((Object)highlighter.filter) && DumbService.isDumb((Project)highlighter.myProject)) {
                return;
            }
            while (highlighter.hasUnprocessedLines()) {
                ProgressManager.checkCanceled();
                this.addLineResult(highlighter.analyzeNextLine());
            }
            LOG.assertTrue(highlighter == this.myQueue.remove());
        }
    }

    private static Filter.Result checkRange(Filter filter2, int endOffset, Filter.Result result2) {
        if (result2 != null) {
            for (Filter.ResultItem resultItem : result2.getResultItems()) {
                int start2 = resultItem.getHighlightStartOffset();
                int end = resultItem.getHighlightEndOffset();
                if (end >= start2 && end <= endOffset) continue;
                LOG.error("Filter returned wrong range: start=" + start2 + "; end=" + end + "; max=" + endOffset + "; filter=" + filter2);
            }
        }
        return result2;
    }

    private static class DeltaTracker {
        private final int initialMarkerOffset;
        private final RangeMarker endMarker;

        DeltaTracker(Document document, int offset) {
            this.initialMarkerOffset = offset;
            this.endMarker = document.createRangeMarker(this.initialMarkerOffset, this.initialMarkerOffset);
        }

        boolean isOutdated() {
            return !this.endMarker.isValid() || this.endMarker.getEndOffset() == 0;
        }

        int getOffsetDelta() {
            return this.endMarker.getStartOffset() - this.initialMarkerOffset;
        }
    }

    private class HighlighterJob {
        @NotNull
        private final Project myProject;
        private final AtomicInteger startLine;
        private final int endLine;
        private final DeltaTracker delta;
        @NotNull
        private final Filter filter;
        @NotNull
        private final Document snapshot;

        HighlighterJob(@NotNull Project project, Filter filter2, int startLine, @NotNull int endLine, Document document) {
            this.myProject = project;
            this.startLine = new AtomicInteger(startLine);
            this.endLine = endLine;
            this.filter = filter2;
            this.delta = new DeltaTracker(document, document.getLineEndOffset(endLine));
            this.snapshot = ((DocumentImpl)document).freeze();
        }

        boolean hasUnprocessedLines() {
            return !this.delta.isOutdated() && this.startLine.get() <= this.endLine;
        }

        @Nullable
        private FilterResult analyzeNextLine() {
            int line = this.startLine.get();
            Filter.Result result2 = this.analyzeLine(line);
            LOG.assertTrue(line == this.startLine.getAndIncrement());
            return result2 == null ? null : new FilterResult(this.delta, result2);
        }

        private Filter.Result analyzeLine(int line) {
            int lineStart = this.snapshot.getLineStartOffset(line);
            if (lineStart + this.delta.getOffsetDelta() < 0) {
                return null;
            }
            String lineText = EditorHyperlinkSupport.getLineText(this.snapshot, line, true);
            int endOffset = lineStart + lineText.length();
            return AsyncFilterRunner.checkRange(this.filter, endOffset, this.filter.applyFilter(lineText, endOffset));
        }
    }

    private class FilterResult {
        private final DeltaTracker myDelta;
        private final Filter.Result myResult;

        FilterResult(DeltaTracker delta, Filter.Result result2) {
            this.myDelta = delta;
            this.myResult = result2;
        }

        void applyHighlights() {
            if (!this.myDelta.isOutdated()) {
                AsyncFilterRunner.this.myHyperlinks.highlightHyperlinks(this.myResult, this.myDelta.getOffsetDelta());
            }
        }
    }
}

