/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleFilesHyperlinkInfo
extends HyperlinkInfoBase
implements FileHyperlinkInfo {
    private final List<? extends VirtualFile> myVirtualFiles;
    private final int myLineNumber;
    private final Project myProject;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HyperlinkInfoFactory.HyperlinkHandler myAction;

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project) {
        this(virtualFiles, lineNumber, project, null);
    }

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project, @Nullable HyperlinkInfoFactory.HyperlinkHandler action2) {
        this.myVirtualFiles = virtualFiles;
        this.myLineNumber = lineNumber;
        this.myProject = project;
        this.myAction = action2;
    }

    public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
        Editor originalEditor;
        ArrayList currentFiles = new ArrayList();
        if (hyperlinkLocationPoint != null) {
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext(hyperlinkLocationPoint.getOriginalComponent());
            originalEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        } else {
            originalEditor = null;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            for (VirtualFile virtualFile : this.myVirtualFiles) {
                PsiFile psiFile;
                if (!virtualFile.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) == null) continue;
                PsiElement navigationElement = psiFile.getNavigationElement();
                if (navigationElement instanceof PsiFile) {
                    currentFiles.add((PsiFile)navigationElement);
                    continue;
                }
                currentFiles.add(psiFile);
            }
        });
        if (currentFiles.isEmpty()) {
            return;
        }
        if (currentFiles.size() == 1) {
            this.open((PsiFile)currentFiles.get(0), originalEditor);
        } else {
            JFrame frame = WindowManager.getInstance().getFrame(project);
            int width = frame != null ? frame.getSize().width : 200;
            JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(currentFiles).setRenderer((ListCellRenderer)new GotoFileCellRenderer(width)).setTitle(ExecutionBundle.message((String)"popup.title.choose.target.file", (Object[])new Object[0])).setItemChosenCallback(file2 -> this.open((PsiFile)file2, originalEditor)).createPopup();
            if (hyperlinkLocationPoint != null) {
                popup2.show(hyperlinkLocationPoint);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    private void open(@NotNull PsiFile file2, Editor originalEditor) {
        Document document = file2.getViewProvider().getDocument();
        int offset = 0;
        if (document != null && this.myLineNumber >= 0 && this.myLineNumber < document.getLineCount()) {
            offset = document.getLineStartOffset(this.myLineNumber);
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, file2.getVirtualFile(), offset);
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor2, true);
        if (this.myAction != null && editor != null) {
            this.myAction.onLinkFollowed(file2, editor, originalEditor);
        }
    }

    @Nullable
    public OpenFileDescriptor getDescriptor() {
        VirtualFile file2 = this.getPreferredFile();
        return file2 != null ? new OpenFileDescriptor(this.myProject, file2, this.myLineNumber, 0) : null;
    }

    @Nullable
    private VirtualFile getPreferredFile() {
        return (VirtualFile)ContainerUtil.getFirstItem(this.myVirtualFiles);
    }
}

