/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextConsoleBuilderImpl
extends TextConsoleBuilder {
    private final Project myProject;
    private final GlobalSearchScope myScope;
    private final List<Filter> myFilters = new SmartList();
    private boolean myViewer;
    private boolean myUsePredefinedMessageFilter = true;

    public TextConsoleBuilderImpl(@NotNull Project project) {
        this(project, GlobalSearchScope.allScope((Project)project));
    }

    public TextConsoleBuilderImpl(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        this.myProject = project;
        this.myScope = scope;
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.createConsole();
        for (Filter filter2 : this.myFilters) {
            consoleView.addMessageFilter(filter2);
        }
        return consoleView;
    }

    @NotNull
    protected ConsoleView createConsole() {
        return new ConsoleViewImpl(this.myProject, this.myScope, this.myViewer, this.myUsePredefinedMessageFilter);
    }

    public void addFilter(@NotNull Filter filter2) {
        this.myFilters.add(filter2);
    }

    @NotNull
    public TextConsoleBuilder filters(@NotNull List<? extends Filter> filters) {
        this.myFilters.addAll(filters);
        return this;
    }

    public void setViewer(boolean isViewer) {
        this.myViewer = isViewer;
    }

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    protected GlobalSearchScope getScope() {
        return this.myScope;
    }

    @NotNull
    protected List<Filter> getFilters() {
        return this.myFilters;
    }

    protected boolean isViewer() {
        return this.myViewer;
    }

    public void setUsePredefinedMessageFilter(boolean usePredefinedMessageFilter) {
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
    }

    public boolean isUsePredefinedMessageFilter() {
        return this.myUsePredefinedMessageFilter;
    }
}

