/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import org.jetbrains.annotations.NotNull;

public class FileHyperlinkRawData {
    private final String myFilePath;
    private final int myDocumentLine;
    private final int myDocumentColumn;
    private final int myHyperlinkStartInd;
    private final int myHyperlinkEndInd;

    public FileHyperlinkRawData(@NotNull String filePath, int documentLine, int documentColumn, int hyperlinkStartInd, int hyperlinkEndInd) {
        this.myFilePath = filePath;
        this.myDocumentLine = documentLine;
        this.myDocumentColumn = documentColumn;
        this.myHyperlinkStartInd = hyperlinkStartInd;
        this.myHyperlinkEndInd = hyperlinkEndInd;
    }

    @NotNull
    public String getFilePath() {
        return this.myFilePath;
    }

    public int getDocumentLine() {
        return this.myDocumentLine;
    }

    public int getDocumentColumn() {
        return this.myDocumentColumn;
    }

    public int getHyperlinkStartInd() {
        return this.myHyperlinkStartInd;
    }

    public int getHyperlinkEndInd() {
        return this.myHyperlinkEndInd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHyperlinkRawData data2 = (FileHyperlinkRawData)o;
        return this.myDocumentLine == data2.myDocumentLine && this.myDocumentColumn == data2.myDocumentColumn && this.myHyperlinkStartInd == data2.myHyperlinkStartInd && this.myHyperlinkEndInd == data2.myHyperlinkEndInd && this.myFilePath.equals(data2.myFilePath);
    }

    public int hashCode() {
        int result2 = this.myFilePath.hashCode();
        result2 = 31 * result2 + this.myDocumentLine;
        result2 = 31 * result2 + this.myDocumentColumn;
        result2 = 31 * result2 + this.myHyperlinkStartInd;
        result2 = 31 * result2 + this.myHyperlinkEndInd;
        return result2;
    }

    public String toString() {
        return "filePath=" + this.myFilePath + ", line=" + this.myDocumentLine + ", column=" + this.myDocumentColumn + ", hyperlinkStartOffset=" + this.myHyperlinkStartInd + ", hyperlinkEndOffset=" + this.myHyperlinkEndInd;
    }
}

