/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RunDashboardGroupingRuleToggleAction
extends ToggleAction
implements DumbAware {
    RunDashboardGroupingRuleToggleAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        ServiceViewOptions viewOptions = (ServiceViewOptions)e.getData(ServiceViewActionUtils.OPTIONS_KEY);
        if (viewOptions != null && !viewOptions.isGroupByServiceGroups()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set contributors = (Set)e.getData(ServiceViewActionUtils.CONTRIBUTORS_KEY);
        if (contributors != null) {
            for (ServiceViewContributor contributor : contributors) {
                if (!(contributor instanceof RunDashboardServiceViewContributor)) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(this.getRuleName(), true);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project).setValue(this.getRuleName(), state, true);
        ((ServiceEventListener)project.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(RunDashboardServiceViewContributor.class));
    }

    @NotNull
    protected abstract String getRuleName();
}

