/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class RestoreConfigurationAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        RunDashboardRunConfigurationNode node = project == null ? null : RunDashboardActionUtils.getTarget(e);
        boolean enabled = node != null && !RunManager.getInstance((Project)project).hasSettings(node.getConfigurationSettings());
        e.getPresentation().setEnabled(enabled);
        boolean popupPlace = ActionPlaces.isPopupPlace((String)e.getPlace());
        e.getPresentation().setVisible(enabled || !popupPlace);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RunDashboardRunConfigurationNode node;
        Project project = e.getProject();
        RunDashboardRunConfigurationNode runDashboardRunConfigurationNode = node = project == null ? null : RunDashboardActionUtils.getTarget(e);
        if (node == null) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = node.getConfigurationSettings();
        runManager.setUniqueNameIfNeeded(settings.getConfiguration());
        if (settings.isTemporary()) {
            runManager.setTemporaryConfiguration(settings);
        } else {
            runManager.addConfiguration(settings);
        }
    }
}

