/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RemoveRunConfigurationTypeAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Set<ConfigurationType> types = RemoveRunConfigurationTypeAction.getTargetTypes(e);
        if (types.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Presentation presentation2 = e.getPresentation();
        presentation2.setEnabledAndVisible(true);
        presentation2.setText(ExecutionBundle.messagePointer((String)"run.dashboard.remove.run.configuration.type.action.name", (Object[])new Object[]{types.size()}));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        HashSet types = new HashSet(runDashboardManager.getTypes());
        Set<ConfigurationType> targetTypes = RemoveRunConfigurationTypeAction.getTargetTypes(e);
        for (ConfigurationType type : targetTypes) {
            types.remove(type.getId());
        }
        runDashboardManager.setTypes(types);
    }

    private static Set<ConfigurationType> getTargetTypes(AnActionEvent e) {
        JBIterable nodes = ServiceViewActionUtils.getTargets((AnActionEvent)e, RunDashboardRunConfigurationNode.class);
        return nodes.map(node -> node.getConfigurationSettings().getType()).toSet();
    }
}

