/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleViewWrapperBase
implements ConsoleView,
ExecutionConsoleEx {
    @NotNull
    private final ConsoleView myDelegate;

    public ConsoleViewWrapperBase(@NotNull ConsoleView delegate) {
        this.myDelegate = delegate;
    }

    @NotNull
    public ConsoleView getDelegate() {
        return this.myDelegate;
    }

    public void requestScrollingToEnd() {
        this.myDelegate.requestScrollingToEnd();
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        this.myDelegate.print(text, contentType);
    }

    public void clear() {
        this.myDelegate.clear();
    }

    public void scrollTo(int offset) {
        this.myDelegate.scrollTo(offset);
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        this.myDelegate.attachToProcess(processHandler2);
    }

    public void setOutputPaused(boolean value2) {
        this.myDelegate.setOutputPaused(value2);
    }

    public boolean isOutputPaused() {
        return this.myDelegate.isOutputPaused();
    }

    public boolean hasDeferredOutput() {
        return this.myDelegate.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        this.myDelegate.performWhenNoDeferredOutput(runnable2);
    }

    public void setHelpId(@NotNull String helpId) {
        this.myDelegate.setHelpId(helpId);
    }

    public void addMessageFilter(@NotNull Filter filter2) {
        this.myDelegate.addMessageFilter(filter2);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        this.myDelegate.printHyperlink(hyperlinkText, info);
    }

    public int getContentSize() {
        return this.myDelegate.getContentSize();
    }

    public boolean canPause() {
        return this.myDelegate.canPause();
    }

    public AnAction @NotNull [] createConsoleActions() {
        return this.myDelegate.createConsoleActions();
    }

    public void allowHeavyFilters() {
        this.myDelegate.allowHeavyFilters();
    }

    public void buildUi(RunnerLayoutUi layoutUi) {
        if (this.myDelegate instanceof ExecutionConsoleEx) {
            ((ExecutionConsoleEx)this.myDelegate).buildUi(layoutUi);
        } else {
            RunContentBuilder.buildConsoleUiDefault(layoutUi, (ExecutionConsole)this);
        }
    }

    @Nullable
    public String getExecutionConsoleId() {
        return this.myDelegate instanceof ExecutionConsoleEx ? ((ExecutionConsoleEx)this.myDelegate).getExecutionConsoleId() : null;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myDelegate.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myDelegate.getPreferredFocusableComponent();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDelegate);
    }
}

