/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0018H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020-J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0002R&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lcom/intellij/execution/console/ConsolePromptDecorator;", "Lcom/intellij/openapi/editor/EditorLinePainter;", "Lcom/intellij/openapi/editor/TextAnnotationGutterProvider;", "myEditorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "indentPrompt", "", "getIndentPrompt", "()Ljava/lang/String;", "setIndentPrompt", "(Ljava/lang/String;)V", "mainPrompt", "getMainPrompt", "setMainPrompt", "promptAttributes", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getPromptAttributes", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "setPromptAttributes", "(Lcom/intellij/execution/ui/ConsoleViewContentType;)V", "getBgColor", "Ljava/awt/Color;", "line", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getColor", "Lcom/intellij/openapi/editor/colors/ColorKey;", "getLineExtensions", "", "Lcom/intellij/openapi/editor/LineExtensionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "getLineText", "getPopupActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getStyle", "Lcom/intellij/openapi/editor/colors/EditorFontType;", "getToolTip", "gutterClosed", "", "update", "useMargin", "", "wrapPrompt", "prompt", "Companion", "intellij.platform.lang.impl"})
public final class ConsolePromptDecorator
extends EditorLinePainter
implements TextAnnotationGutterProvider {
    @NotNull
    private String mainPrompt;
    @NotNull
    private ConsoleViewContentType promptAttributes;
    @NotNull
    private String indentPrompt;
    private final EditorEx myEditorEx;
    private static final ColorKey promptColor;
    public static final Companion Companion;

    @NotNull
    public final String getMainPrompt() {
        return this.myEditorEx.isRendererMode() ? "" : this.mainPrompt;
    }

    public final void setMainPrompt(@NotNull String mainPrompt) {
        String mainPromptWrapped = this.wrapPrompt(mainPrompt);
        if (Intrinsics.areEqual((Object)this.getMainPrompt(), (Object)mainPromptWrapped) ^ true) {
            this.setIndentPrompt("");
            this.mainPrompt = mainPromptWrapped;
            this.update();
        }
    }

    @NotNull
    public final ConsoleViewContentType getPromptAttributes() {
        return this.promptAttributes;
    }

    public final void setPromptAttributes(@NotNull ConsoleViewContentType promptAttributes) {
        this.promptAttributes = promptAttributes;
        this.myEditorEx.getColorsScheme().setColor(promptColor, promptAttributes.getAttributes().getForegroundColor());
        this.update();
    }

    @NotNull
    public final String getIndentPrompt() {
        return this.myEditorEx.isRendererMode() ? "" : this.indentPrompt;
    }

    public final void setIndentPrompt(@NotNull String indentPrompt) {
        String indentPromptWrapped;
        this.indentPrompt = indentPromptWrapped = this.wrapPrompt(indentPrompt);
        this.update();
    }

    private final String wrapPrompt(String prompt) {
        return !StringsKt.endsWith$default((String)prompt, (String)" ", (boolean)false, (int)2, null) ? prompt + ' ' : prompt;
    }

    @Override
    @Nullable
    public Collection<LineExtensionInfo> getLineExtensions(@NotNull Project project, @NotNull VirtualFile file2, int lineNumber) {
        return null;
    }

    @Nullable
    public String getLineText(int line, @NotNull Editor editor) {
        if (line == 0) {
            return this.getMainPrompt();
        }
        if (line > 0) {
            return this.getIndentPrompt();
        }
        return null;
    }

    @Nullable
    public String getToolTip(int line, @NotNull Editor editor) {
        return null;
    }

    @NotNull
    public EditorFontType getStyle(int line, @NotNull Editor editor) {
        return EditorFontType.CONSOLE_PLAIN;
    }

    @Nullable
    public ColorKey getColor(int line, @NotNull Editor editor) {
        return promptColor;
    }

    @Nullable
    public Color getBgColor(int line, @NotNull Editor editor) {
        Color backgroundColor = this.promptAttributes.getAttributes().getBackgroundColor();
        if (backgroundColor == null) {
            backgroundColor = this.myEditorEx.getBackgroundColor();
        }
        return backgroundColor;
    }

    @Nullable
    public List<AnAction> getPopupActions(int line, @NotNull Editor editor) {
        return null;
    }

    public void gutterClosed() {
    }

    public boolean useMargin() {
        return false;
    }

    public final void update() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ ConsolePromptDecorator this$0;

            public final void run() {
                ConsolePromptDecorator.access$getMyEditorEx$p(this.this$0).getGutterComponentEx().revalidateMarkup();
            }
            {
                this.this$0 = consolePromptDecorator;
            }
        });
    }

    public ConsolePromptDecorator(@NotNull EditorEx myEditorEx) {
        this.myEditorEx = myEditorEx;
        this.mainPrompt = "> ";
        this.promptAttributes = ConsoleViewContentType.USER_INPUT;
        this.indentPrompt = "";
        this.myEditorEx.getColorsScheme().setColor(promptColor, this.promptAttributes.getAttributes().getForegroundColor());
    }

    static {
        Companion = new Companion(null);
        promptColor = ColorKey.createColorKey((String)"CONSOLE_PROMPT_COLOR");
    }

    public static final /* synthetic */ EditorEx access$getMyEditorEx$p(ConsolePromptDecorator $this) {
        return $this.myEditorEx;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/console/ConsolePromptDecorator$Companion;", "", "()V", "promptColor", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

