/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesTextFieldWithBrowseButton
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    private EnvironmentVariablesData myData = EnvironmentVariablesData.DEFAULT;
    private final Map<String, String> myParentDefaults = new LinkedHashMap<String, String>();
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesTextFieldWithBrowseButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(EnvVariablesTable.parseEnvsFromText((String)EnvironmentVariablesTextFieldWithBrowseButton.this.getText()));
                new MyEnvironmentVariablesDialog().show();
            }
        });
        this.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (!StringUtil.equals((CharSequence)EnvironmentVariablesTextFieldWithBrowseButton.stringifyEnvs(EnvironmentVariablesTextFieldWithBrowseButton.this.myData.getEnvs()), (CharSequence)EnvironmentVariablesTextFieldWithBrowseButton.this.getText())) {
                    Map textEnvs = EnvVariablesTable.parseEnvsFromText((String)EnvironmentVariablesTextFieldWithBrowseButton.this.getText());
                    EnvironmentVariablesTextFieldWithBrowseButton.this.myData = EnvironmentVariablesData.create(textEnvs, EnvironmentVariablesTextFieldWithBrowseButton.this.myData.isPassParentEnvs());
                    EnvironmentVariablesTextFieldWithBrowseButton.this.fireStateChanged();
                }
            }
        });
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return this.myData.getEnvs();
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        this.setData(EnvironmentVariablesData.create(envs, this.myData.isPassParentEnvs()));
    }

    @NotNull
    public EnvironmentVariablesData getData() {
        return this.myData;
    }

    public void setData(@NotNull EnvironmentVariablesData data2) {
        EnvironmentVariablesData oldData = this.myData;
        this.myData = data2;
        this.setText(EnvironmentVariablesTextFieldWithBrowseButton.stringifyEnvs(data2.getEnvs()));
        if (!oldData.equals(data2)) {
            this.fireStateChanged();
        }
    }

    @NotNull
    protected Icon getDefaultIcon() {
        return AllIcons.General.InlineVariables;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        return AllIcons.General.InlineVariablesHover;
    }

    @NotNull
    private static String stringifyEnvs(@NotNull Map<String, String> envs) {
        if (envs.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(StringUtil.escapeChar((String)entry.getKey(), (char)';')).append("=").append(StringUtil.escapeChar((String)entry.getValue(), (char)';'));
        }
        return buf.toString();
    }

    public boolean isPassParentEnvs() {
        return this.myData.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.setData(EnvironmentVariablesData.create(this.myData.getEnvs(), passParentEnvs));
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener2 : this.myListeners) {
            listener2.stateChanged(new ChangeEvent((Object)this));
        }
    }

    private static List<EnvironmentVariable> convertToVariables(Map<String, String> map2, final boolean readOnly) {
        return ContainerUtil.map(map2.entrySet(), entry -> new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue(), readOnly){

            public boolean getNameIsWriteable() {
                return !readOnly;
            }
        });
    }

    private boolean isModifiedSysEnv(@NotNull EnvironmentVariable v) {
        return !v.getNameIsWriteable() && !Objects.equals(v.getValue(), this.myParentDefaults.get(v.getName()));
    }

    private class MyEnvVariablesTable
    extends EnvVariablesTable {
        private final boolean myUserList;

        private MyEnvVariablesTable(List<EnvironmentVariable> list2, boolean userList) {
            this.myUserList = userList;
            TableView tableView = this.getTableView();
            tableView.setVisibleRowCount(7);
            this.setValues(list2);
            this.setPasteActionEnabled(this.myUserList);
        }

        @Nullable
        protected AnActionButtonRunnable createAddAction() {
            return this.myUserList ? super.createAddAction() : null;
        }

        @Nullable
        protected AnActionButtonRunnable createRemoveAction() {
            return this.myUserList ? super.createRemoveAction() : null;
        }

        protected AnActionButton @NotNull [] createExtraActions() {
            return this.myUserList ? super.createExtraActions() : (AnActionButton[])ArrayUtil.append((Object[])super.createExtraActions(), (Object)new AnActionButton(ActionsBundle.message((String)"action.ChangesView.Revert.text", (Object[])new Object[0]), AllIcons.Actions.Rollback){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    MyEnvVariablesTable.this.stopEditing();
                    List variables = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable environmentVariable : variables) {
                        if (!EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(environmentVariable)) continue;
                        environmentVariable.setValue((String)EnvironmentVariablesTextFieldWithBrowseButton.this.myParentDefaults.get(environmentVariable.getName()));
                        MyEnvVariablesTable.this.setModified();
                    }
                    MyEnvVariablesTable.this.getTableView().revalidate();
                    MyEnvVariablesTable.this.getTableView().repaint();
                }

                public boolean isEnabled() {
                    List selection = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable variable : selection) {
                        if (!EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(variable)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }

        protected ListTableModel createListModel() {
            return new ListTableModel(new ColumnInfo[]{new MyNameColumnInfo(), new MyValueColumnInfo()});
        }

        protected class MyValueColumnInfo
        extends EnvVariablesTable.ValueColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer;

            protected MyValueColumnInfo() {
                super((EnvVariablesTable)MyEnvVariablesTable.this);
                this.myModifiedRenderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                        component2.setFont(component2.getFont().deriveFont(1));
                        if (!hasFocus && !isSelected) {
                            component2.setForeground(JBUI.CurrentTheme.Link.linkColor());
                        }
                        return component2;
                    }
                };
            }

            public boolean isCellEditable(EnvironmentVariable environmentVariable) {
                return true;
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer) {
                return EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(o) ? this.myModifiedRenderer : renderer;
            }
        }

        protected class MyNameColumnInfo
        extends EnvVariablesTable.NameColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer;

            protected MyNameColumnInfo() {
                super((EnvVariablesTable)MyEnvVariablesTable.this);
                this.myModifiedRenderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                        component2.setEnabled(table.isEnabled() && (hasFocus || isSelected));
                        return component2;
                    }
                };
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer) {
                return o.getNameIsWriteable() ? renderer : this.myModifiedRenderer;
            }
        }
    }

    private class MyEnvironmentVariablesDialog
    extends DialogWrapper {
        private final EnvVariablesTable myUserTable;
        private final EnvVariablesTable mySystemTable;
        private final JCheckBox myIncludeSystemVarsCb;
        private final JPanel myWholePanel;

        protected MyEnvironmentVariablesDialog() {
            super((Component)((Object)EnvironmentVariablesTextFieldWithBrowseButton.this), true);
            LinkedHashMap<String, String> userMap = new LinkedHashMap<String, String>(EnvironmentVariablesTextFieldWithBrowseButton.this.myData.getEnvs());
            TreeMap parentMap = new TreeMap(new GeneralCommandLine().getParentEnvironment());
            EnvironmentVariablesTextFieldWithBrowseButton.this.myParentDefaults.putAll(parentMap);
            Iterator iterator2 = userMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                if (!parentMap.containsKey(entry.getKey())) continue;
                parentMap.put(entry.getKey(), entry.getValue());
                iterator2.remove();
            }
            List userList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(userMap, false);
            List systemList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(parentMap, true);
            this.myUserTable = new MyEnvVariablesTable(userList, true);
            this.mySystemTable = new MyEnvVariablesTable(systemList, false);
            this.myIncludeSystemVarsCb = new JCheckBox(ExecutionBundle.message((String)"env.vars.system.title", (Object[])new Object[0]));
            this.myIncludeSystemVarsCb.setSelected(EnvironmentVariablesTextFieldWithBrowseButton.this.isPassParentEnvs());
            this.myIncludeSystemVarsCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyEnvironmentVariablesDialog.this.updateSysTableState();
                }
            });
            JLabel label2 = new JLabel(ExecutionBundle.message((String)"env.vars.user.title", (Object[])new Object[0]));
            label2.setLabelFor(this.myUserTable.getTableView().getComponent());
            this.myWholePanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0, gap 0, hidemode 3"));
            this.myWholePanel.add((Component)label2, "hmax pref, wrap");
            this.myWholePanel.add((Component)this.myUserTable.getComponent(), "push, grow, wrap, gaptop 5");
            this.myWholePanel.add((Component)this.myIncludeSystemVarsCb, "hmax pref, wrap, gaptop 5");
            this.myWholePanel.add((Component)this.mySystemTable.getComponent(), "push, grow, wrap, gaptop 5");
            this.updateSysTableState();
            this.setTitle(ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]));
            this.init();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return "EnvironmentVariablesDialog";
        }

        private void updateSysTableState() {
            this.mySystemTable.getTableView().setEnabled(this.myIncludeSystemVarsCb.isSelected());
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
                String name = variable.getName();
                String value2 = variable.getValue();
                if (StringUtil.isEmpty((String)name) && StringUtil.isEmpty((String)value2)) continue;
                if (!EnvironmentUtil.isValidName((String)name)) {
                    return new ValidationInfo(IdeUtilIoBundle.message((String)"run.configuration.invalid.env.name", (Object[])new Object[]{name}));
                }
                if (EnvironmentUtil.isValidValue((String)value2)) continue;
                return new ValidationInfo(IdeUtilIoBundle.message((String)"run.configuration.invalid.env.value", (Object[])new Object[]{name, value2}));
            }
            return super.doValidate();
        }

        protected void doOKAction() {
            this.myUserTable.stopEditing();
            LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
            for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
                if (StringUtil.isEmpty((String)variable.getName()) && StringUtil.isEmpty((String)variable.getValue())) continue;
                envs.put(variable.getName(), variable.getValue());
            }
            for (EnvironmentVariable variable : this.mySystemTable.getEnvironmentVariables()) {
                if (!EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(variable)) continue;
                envs.put(variable.getName(), variable.getValue());
            }
            EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(envs);
            EnvironmentVariablesTextFieldWithBrowseButton.this.setPassParentEnvs(this.myIncludeSystemVarsCb.isSelected());
            super.doOKAction();
        }
    }
}

