/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ThreeState;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunConfigurationAction
extends ActionGroup {
    protected static final Logger LOG = Logger.getInstance(BaseRunConfigurationAction.class);
    @Nullable
    private static Integer ourLastTimeoutStamp = null;

    protected BaseRunConfigurationAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, Icon icon2) {
        super(text, description, icon2);
        this.setPopup(true);
        this.setEnabledInModalContext(true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return e != null ? this.getChildren(e.getDataContext()) : EMPTY_ARRAY;
    }

    private AnAction[] getChildren(DataContext dataContext) {
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        if (!Registry.is((String)"suggest.all.run.configurations.from.context") && context.findExisting() != null) {
            return EMPTY_ARRAY;
        }
        return this.createChildActions(context, this.getConfigurationsFromContext(context)).toArray(EMPTY_ARRAY);
    }

    @NotNull
    protected List<AnAction> createChildActions(final @NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (configurations.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>();
        for (final ConfigurationFromContext configurationFromContext : configurations) {
            ConfigurationType configurationType = configurationFromContext.getConfigurationType();
            String actionName = BaseRunConfigurationAction.childActionName(configurationFromContext);
            AnAction anAction = new AnAction(actionName, configurationType.getDisplayName(), configurationFromContext.getConfiguration().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    BaseRunConfigurationAction.this.perform(configurationFromContext, context);
                }
            };
            anAction.getTemplatePresentation().setText(actionName, false);
            childActions.add(anAction);
        }
        return childActions;
    }

    @NotNull
    private List<ConfigurationFromContext> getConfigurationsFromContext(ConfigurationContext context) {
        List fromContext = context.getConfigurationsFromContext();
        if (fromContext == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigurationFromContext> enabledConfigurations = new ArrayList<ConfigurationFromContext>();
        for (ConfigurationFromContext configurationFromContext : fromContext) {
            if (!this.isEnabledFor(configurationFromContext.getConfiguration())) continue;
            enabledConfigurations.add(configurationFromContext);
        }
        return enabledConfigurations;
    }

    protected boolean isEnabledFor(RunConfiguration configuration) {
        return true;
    }

    public boolean canBePerformed(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && DumbService.isDumb((Project)project)) {
            return false;
        }
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            return fromContext.size() <= 1;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> producers = this.getConfigurationsFromContext(context);
            if (producers.isEmpty()) {
                return;
            }
            if (producers.size() > 1) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                producers.sort(ConfigurationFromContext.NAME_COMPARATOR);
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationFromContext>(ExecutionBundle.message((String)"configuration.action.chooser.title", (Object[])new Object[0]), producers){

                    @NotNull
                    public String getTextFor(ConfigurationFromContext producer) {
                        return BaseRunConfigurationAction.childActionName(producer);
                    }

                    public Icon getIconFor(ConfigurationFromContext producer) {
                        return producer.getConfigurationType().getIcon();
                    }

                    public PopupStep<?> onChosen(ConfigurationFromContext producer, boolean finalChoice) {
                        BaseRunConfigurationAction.this.perform(producer, context);
                        return FINAL_CHOICE;
                    }
                });
                InputEvent event = e.getInputEvent();
                if (event instanceof MouseEvent) {
                    popup2.show(new RelativePoint((MouseEvent)event));
                } else if (editor != null) {
                    popup2.showInBestPositionFor(editor);
                } else {
                    popup2.showInBestPositionFor(dataContext);
                }
            } else {
                this.perform(producers.get(0), context);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            String configurationClass = existing.getConfiguration().getClass().getName();
            LOG.debug(String.format("Use existing run configuration: %s", configurationClass));
        }
        this.perform(context);
    }

    private void perform(ConfigurationFromContext configurationFromContext, ConfigurationContext context) {
        RunnerAndConfigurationSettings configurationSettings = configurationFromContext.getConfigurationSettings();
        context.setConfiguration(configurationSettings);
        configurationFromContext.onFirstRun(context, () -> {
            if (LOG.isDebugEnabled()) {
                RunnerAndConfigurationSettings settings = context.getConfiguration();
                RunConfiguration configuration = settings == null ? null : settings.getConfiguration();
                String configurationClass = configuration == null ? null : configuration.getClass().getName();
                LOG.debug(String.format("Create run configuration: %s", configurationClass));
            }
            this.perform(context);
        });
    }

    protected abstract void perform(ConfigurationContext var1);

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        this.fullUpdate(e);
    }

    public void update(@NotNull AnActionEvent event) {
        boolean success;
        ThreeState hadAnythingRunnable;
        VirtualFile vFile = (VirtualFile)event.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE);
        ThreeState threeState = hadAnythingRunnable = vFile == null ? ThreeState.UNSURE : RunLineMarkerProvider.hadAnythingRunnable(vFile);
        if (hadAnythingRunnable == ThreeState.UNSURE) {
            this.fullUpdate(event);
            return;
        }
        boolean bl = success = !BaseRunConfigurationAction.alreadyExceededTimeoutOnSimilarAction() && ProgressIndicatorUtils.withTimeout(Registry.intValue((String)"run.configuration.update.timeout"), () -> {
            this.fullUpdate(event);
            return true;
        }) != null;
        if (!success) {
            BaseRunConfigurationAction.recordUpdateTimeout();
            this.approximatePresentationByPreviousAvailability(event, hadAnythingRunnable);
        }
    }

    private static boolean alreadyExceededTimeoutOnSimilarAction() {
        return Objects.equals(IdeEventQueue.getInstance().getEventCount(), ourLastTimeoutStamp);
    }

    private static void recordUpdateTimeout() {
        ourLastTimeoutStamp = IdeEventQueue.getInstance().getEventCount();
    }

    protected void approximatePresentationByPreviousAvailability(AnActionEvent event, ThreeState hadAnythingRunnable) {
        event.getPresentation().copyFrom(this.getTemplatePresentation());
        event.getPresentation().setEnabledAndVisible(hadAnythingRunnable == ThreeState.YES);
    }

    protected void fullUpdate(@NotNull AnActionEvent event) {
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)event.getDataContext());
        Presentation presentation2 = event.getPresentation();
        RunnerAndConfigurationSettings existing = context.findExisting();
        RunnerAndConfigurationSettings configuration = existing;
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        if (configuration == null) {
            presentation2.setEnabledAndVisible(false);
        } else {
            presentation2.setEnabledAndVisible(true);
            VirtualFile vFile = (VirtualFile)event.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE);
            if (vFile != null) {
                RunLineMarkerProvider.markRunnable(vFile, true);
            }
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            if (existing == null && !fromContext.isEmpty()) {
                context.setConfiguration(fromContext.get(0).getConfigurationSettings());
            }
            String name = BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration.getConfiguration());
            this.updatePresentation(presentation2, existing != null || fromContext.size() <= 1 ? name : "", context);
        }
    }

    public boolean isDumbAware() {
        return false;
    }

    @NotNull
    public static String suggestRunActionName(@NotNull LocatableConfiguration configuration) {
        String actionName;
        if (configuration instanceof LocatableConfigurationBase && configuration.isGeneratedName() && (actionName = ((LocatableConfigurationBase)configuration).getActionName()) != null) {
            return actionName;
        }
        return ProgramRunnerUtil.shortenName(configuration.getName(), 0);
    }

    @NotNull
    private static String childActionName(ConfigurationFromContext configurationFromContext) {
        String locationDisplayName;
        RunConfiguration configuration = configurationFromContext.getConfiguration();
        if (!(configuration instanceof LocatableConfiguration)) {
            return configurationFromContext.getConfigurationType().getDisplayName();
        }
        if (configurationFromContext.isFromAlternativeLocation() && (locationDisplayName = configurationFromContext.getAlternativeLocationDisplayName()) != null) {
            return ((LocatableConfigurationBase)configuration).getActionName() + " " + locationDisplayName;
        }
        return StringUtil.unquoteString((String)BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configurationFromContext.getConfiguration()));
    }

    protected abstract void updatePresentation(Presentation var1, @NotNull String var2, ConfigurationContext var3);
}

