/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunManagerEx
extends RunManager {
    @NotNull
    public static RunManagerEx getInstanceEx(@NotNull Project project) {
        return (RunManagerEx)RunManager.getInstance((Project)project);
    }

    @Deprecated
    public final void setActiveConfiguration(@Nullable RunnerAndConfigurationSettings configuration) {
        this.setSelectedConfiguration(configuration);
    }

    @Deprecated
    public final void addConfiguration(RunnerAndConfigurationSettings settings, boolean storeInDotIdeaFolder, List<BeforeRunTask> tasks, boolean addTemplateTasksIfAbsent) {
        if (storeInDotIdeaFolder) {
            settings.storeInDotIdeaFolder();
        } else {
            settings.storeInLocalWorkspace();
        }
        this.setBeforeRunTasks(settings.getConfiguration(), tasks, addTemplateTasksIfAbsent);
        this.addConfiguration(settings);
    }

    @NotNull
    public abstract List<BeforeRunTask> getBeforeRunTasks(@NotNull RunConfiguration var1);

    public abstract void setBeforeRunTasks(@NotNull RunConfiguration var1, @NotNull List<BeforeRunTask> var2);

    @Deprecated
    public final void setBeforeRunTasks(@NotNull RunConfiguration configuration, @NotNull List<BeforeRunTask> tasks, boolean addEnabledTemplateTasksIfAbsent) {
        this.setBeforeRunTasks(configuration, tasks);
    }

    @NotNull
    public abstract <T extends BeforeRunTask> List<T> getBeforeRunTasks(@NotNull RunConfiguration var1, Key<T> var2);

    @NotNull
    public abstract <T extends BeforeRunTask> List<T> getBeforeRunTasks(Key<T> var1);

    public Icon getConfigurationIcon(@NotNull RunnerAndConfigurationSettings settings) {
        return this.getConfigurationIcon(settings, false);
    }

    @NotNull
    public abstract Icon getConfigurationIcon(@NotNull RunnerAndConfigurationSettings var1, boolean var2);

    @Deprecated
    @NotNull
    public final Collection<RunnerAndConfigurationSettings> getSortedConfigurations() {
        return this.getAllSettings();
    }

    @Deprecated
    public void addRunManagerListener(@NotNull RunManagerListener listener2) {
    }

    @SafeVarargs
    public static void disableTasks(Project project, RunConfiguration settings, Key<? extends BeforeRunTask> ... keys2) {
        for (Key<? extends BeforeRunTask> key : keys2) {
            List<? extends BeforeRunTask> tasks = RunManagerEx.getInstanceEx(project).getBeforeRunTasks(settings, key);
            for (BeforeRunTask beforeRunTask : tasks) {
                beforeRunTask.setEnabled(false);
            }
        }
    }

    @SafeVarargs
    public static int getTasksCount(Project project, RunConfiguration settings, Key<? extends BeforeRunTask> ... keys2) {
        return Arrays.stream(keys2).mapToInt(key -> RunManagerEx.getInstanceEx(project).getBeforeRunTasks(settings, (Key)key).size()).sum();
    }
}

