/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentExecutor
implements Disposable {
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final List<Filter> myFilterList = new ArrayList<Filter>();
    private Runnable myRerunAction;
    private Runnable myStopAction;
    private Runnable myAfterCompletion;
    private Computable<Boolean> myStopEnabled;
    private String myTitle = "Output";
    private String myHelpId = null;
    private boolean myActivateToolWindow = true;
    private boolean myFocusToolWindow = true;
    private ConsoleView myUserProvidedConsole;

    public RunContentExecutor(@NotNull Project project, @NotNull ProcessHandler process2) {
        this.myProject = project;
        this.myProcess = process2;
    }

    public RunContentExecutor withFilter(Filter filter2) {
        this.myFilterList.add(filter2);
        return this;
    }

    public RunContentExecutor withTitle(String title) {
        this.myTitle = title;
        return this;
    }

    public RunContentExecutor withRerun(Runnable rerun) {
        this.myRerunAction = rerun;
        return this;
    }

    public RunContentExecutor withStop(@NotNull Runnable stop2, @NotNull Computable<Boolean> stopEnabled) {
        this.myStopAction = stop2;
        this.myStopEnabled = stopEnabled;
        return this;
    }

    public RunContentExecutor withAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
        return this;
    }

    public RunContentExecutor withHelpId(String helpId) {
        this.myHelpId = helpId;
        return this;
    }

    public RunContentExecutor withActivateToolWindow(boolean activateToolWindow2) {
        this.myActivateToolWindow = activateToolWindow2;
        return this;
    }

    public RunContentExecutor withFocusToolWindow(boolean focusToolWindow) {
        this.myFocusToolWindow = focusToolWindow;
        return this;
    }

    private ConsoleView createConsole() {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
        consoleBuilder.filters(this.myFilterList);
        ConsoleView console = consoleBuilder.getConsole();
        if (this.myHelpId != null) {
            console.setHelpId(this.myHelpId);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        JComponent consolePanel = RunContentExecutor.createConsolePanel(console, (ActionGroup)actions);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)console, this.myProcess, consolePanel, this.myTitle);
        descriptor2.setActivateToolWindowWhenAdded(this.myActivateToolWindow);
        descriptor2.setAutoFocusContent(this.myFocusToolWindow);
        Disposer.register((Disposable)descriptor2, (Disposable)this);
        Disposer.register((Disposable)descriptor2, (Disposable)console);
        actions.add((AnAction)new RerunAction(consolePanel));
        actions.add((AnAction)new StopAction());
        actions.add((AnAction)new CloseAction(executor, descriptor2, this.myProject));
        RunContentManager.getInstance((Project)this.myProject).showRunContent(executor, descriptor2);
        return console;
    }

    public void run() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ConsoleView view = this.myUserProvidedConsole != null ? this.myUserProvidedConsole : this.createConsole();
        view.attachToProcess(this.myProcess);
        if (this.myAfterCompletion != null) {
            this.myProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    ApplicationManager.getApplication().invokeLater(RunContentExecutor.this.myAfterCompletion);
                }
            });
        }
        this.myProcess.startNotify();
    }

    private static JComponent createConsolePanel(ConsoleView view, ActionGroup actions) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)view.getComponent(), "Center");
        panel2.add((Component)RunContentExecutor.createToolbar(actions), "West");
        return panel2;
    }

    private static JComponent createToolbar(ActionGroup actions) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("RunContentExecutor", actions, false);
        return actionToolbar.getComponent();
    }

    public void dispose() {
    }

    @NotNull
    public RunContentExecutor withConsole(@Nullable ConsoleView console) {
        this.myUserProvidedConsole = console;
        return this;
    }

    private class StopAction
    extends AnAction
    implements DumbAware {
        StopAction() {
            super(ExecutionBundle.messagePointer((String)"action.AnAction.text.stop", (Object[])new Object[0]), ExecutionBundle.messagePointer((String)"action.AnAction.description.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RunContentExecutor.this.myStopAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(RunContentExecutor.this.myStopAction != null);
            e.getPresentation().setEnabled(RunContentExecutor.this.myStopEnabled != null && (Boolean)RunContentExecutor.this.myStopEnabled.compute() != false);
        }
    }

    private class RerunAction
    extends AnAction {
        RerunAction(JComponent consolePanel) {
            super(CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), AllIcons.Actions.Restart);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consolePanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RunContentExecutor.this.myRerunAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(RunContentExecutor.this.myRerunAction != null);
        }

        public boolean isDumbAware() {
            return true;
        }
    }
}

