/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance(ProgramRunnerUtil.class);

    private ProgramRunnerUtil() {
    }

    @Deprecated
    @Nullable
    public static ProgramRunner<?> getRunner(@NotNull String executorId, @Nullable RunnerAndConfigurationSettings configuration) {
        return configuration == null ? null : ProgramRunner.getRunner((String)executorId, (RunProfile)configuration.getConfiguration());
    }

    public static void executeConfiguration(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId) {
        ProgramRunnerUtil.executeConfigurationAsync(environment, showSettings, assignNewId, null);
    }

    @NotNull
    public static String getCannotRunOnErrorMessage(@NotNull RunProfile profile, @NotNull ExecutionTarget target2) {
        return StringUtil.escapeXmlEntities((String)("Cannot run '" + profile.getName() + "' on '" + target2.getDisplayName() + "'"));
    }

    public static void executeConfigurationAsync(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId, @Nullable ProgramRunner.Callback callback2) {
        ExecutionManagerImpl manager = (ExecutionManagerImpl)ExecutionManager.getInstance((Project)environment.getProject());
        if (!manager.isStarting(environment)) {
            if (callback2 != null) {
                environment.setCallback(callback2);
            }
            manager.executeConfiguration(environment, showSettings, assignNewId);
        }
    }

    public static void handleExecutionError(Project project, @NotNull ExecutionEnvironment environment, Throwable e, RunProfile configuration) {
        String name = configuration != null ? configuration.getName() : environment.getRunProfile().getName();
        String windowId = RunContentManager.getInstance((Project)project).getToolWindowIdByEnvironment(environment);
        if (configuration instanceof ConfigurationWithCommandLineShortener && ExecutionUtil.isProcessNotCreated((Throwable)e)) {
            ProgramRunnerUtil.handleProcessNotStartedError((ConfigurationWithCommandLineShortener)configuration, (ExecutionException)((ProcessNotCreatedException)e), name, windowId);
        } else {
            ExecutionUtil.handleExecutionError((Project)project, (String)windowId, (String)name, (Throwable)e);
        }
    }

    private static void handleProcessNotStartedError(ConfigurationWithCommandLineShortener configuration, ExecutionException e, String name, String windowId) {
        String description = e.getMessage();
        HyperlinkListener listener2 = null;
        Project project = configuration.getProject();
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.getAllSettings().stream().filter(settings -> settings.getConfiguration() == configuration).findFirst().orElse(null);
        if (runnerAndConfigurationSettings != null && (configuration.getShortenCommandLine() == null || configuration.getShortenCommandLine() == ShortenCommandLine.NONE)) {
            ConfigurationFactory factory2 = runnerAndConfigurationSettings.getFactory();
            RunnerAndConfigurationSettings configurationTemplate = runManager.getConfigurationTemplate(factory2);
            description = "Command line is too long. Shorten command line for <a href=\"current\">" + name + "</a>";
            if (((ConfigurationWithCommandLineShortener)configurationTemplate.getConfiguration()).getShortenCommandLine() == null) {
                description = description + " or also for " + factory2.getName() + " <a href=\"default\">default</a> configuration";
            }
            description = description + ".";
            listener2 = event -> {
                boolean isDefaultConfigurationChosen;
                SingleConfigurableEditor dialog2;
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (dialog2 = RunDialog.editShortenClasspathSetting((isDefaultConfigurationChosen = "default".equals(event.getDescription())) ? configurationTemplate : runnerAndConfigurationSettings, ExecutionBundle.message((String)"dialog.title.edit.configuration", (Object[])new Object[]{isDefaultConfigurationChosen ? 1 : 0}))).showAndGet() && isDefaultConfigurationChosen) {
                    configuration.setShortenCommandLine(((ConfigurationWithCommandLineShortener)configurationTemplate.getConfiguration()).getShortenCommandLine());
                }
            };
        }
        ExecutionUtil.handleExecutionError((Project)project, (String)windowId, (String)name, (Throwable)e, (String)description, listener2);
    }

    @Deprecated
    public static void executeConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        ProgramRunnerUtil.executeConfiguration(configuration, executor);
    }

    public static void executeConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        ExecutionEnvironmentBuilder builder2;
        try {
            builder2 = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return;
        }
        ProgramRunnerUtil.executeConfiguration(builder2.contentToReuse(null).dataContext(null).activeTarget().build(), true, true);
    }

    @NotNull
    public static Icon getConfigurationIcon(@NotNull RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        Icon icon2 = ProgramRunnerUtil.getRawIcon(settings);
        Icon icon3 = configurationIcon = settings.isTemporary() ? ProgramRunnerUtil.getTemporaryIcon(icon2) : icon2;
        if (invalid) {
            return LayeredIcon.create((Icon)configurationIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
        }
        return configurationIcon;
    }

    @NotNull
    public static Icon getRawIcon(@NotNull RunnerAndConfigurationSettings settings) {
        Icon icon2 = settings.getFactory().getIcon(settings.getConfiguration());
        return icon2 == null ? AllIcons.Actions.Help : icon2;
    }

    @NotNull
    public static Icon getTemporaryIcon(@NotNull Icon rawIcon) {
        return IconLoader.getTransparentIcon((Icon)rawIcon, (float)0.3f);
    }

    @NotNull
    public static String shortenName(@Nullable String name, int toBeAdded) {
        if (name == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        return name.length() < symbols + 3 ? name : name.substring(0, symbols) + "...";
    }
}

