/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.SmartTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffEditorHighlighterUpdater;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.LineNumberConverterAdapter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Function;
import com.intellij.util.ImageLoader;
import com.intellij.util.LineSeparator;
import com.intellij.util.MathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import gnu.trove.Equality;
import gnu.trove.TIntFunction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    public static final Key<Boolean> TEMP_FILE_KEY = Key.create((String)"Diff.TempFile");
    @NotNull
    @NonNls
    public static final String DIFF_CONFIG = "diff.xml";
    public static final int TITLE_GAP = JBUIScale.scale((int)2);

    @NotNull
    private static List<Image> loadDiffFrameImages() {
        return Arrays.asList(ImageLoader.loadFromResource((String)"/diff_frame32.png"), ImageLoader.loadFromResource((String)"/diff_frame64.png"), ImageLoader.loadFromResource((String)"/diff_frame128.png"));
    }

    public static boolean isDiffEditor(@NotNull Editor editor) {
        return editor.getEditorKind() == EditorKind.DIFF;
    }

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content2, @NotNull CharSequence text) {
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project, content2);
        if (highlighter == null) {
            return null;
        }
        highlighter.setText(text);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text) {
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text);
        return highlighter;
    }

    @Nullable
    public static EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content2) {
        FileType type = content2.getContentType();
        VirtualFile file2 = content2.getHighlightFile();
        Language language = (Language)content2.getUserData(DiffUserDataKeys.LANGUAGE);
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        if (language != null) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file2);
            return highlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        }
        if (file2 != null && file2.isValid() && (type == null || type == PlainTextFileType.INSTANCE || FileTypeRegistry.getInstance().isFileOfType(file2, type) || file2 instanceof LightVirtualFile)) {
            return highlighterFactory.createEditorHighlighter(project, file2);
        }
        if (type != null) {
            return highlighterFactory.createEditorHighlighter(project, type);
        }
        return null;
    }

    @NotNull
    public static EditorHighlighter createEmptyEditorHighlighter() {
        return new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
    }

    public static void setEditorHighlighter(@Nullable Project project, @NotNull EditorEx editor, @NotNull DocumentContent content2) {
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project, content2);
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        }
        if (project != null) {
            new DiffEditorHighlighterUpdater(project, ((EditorImpl)editor).getDisposable(), editor, content2);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project, @NotNull EditorEx editor, @Nullable DocumentContent content2) {
        Language language;
        if (project != null && content2 != null && editor.getVirtualFile() == null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(content2.getDocument());
            CommonCodeStyleSettings.IndentOptions indentOptions = psiFile != null ? CodeStyle.getSettings((PsiFile)psiFile).getIndentOptionsByFile(psiFile) : CodeStyle.getSettings((Project)project).getIndentOptions(content2.getContentType());
            editor.getSettings().setTabSize(indentOptions.TAB_SIZE);
            editor.getSettings().setUseTabCharacter(indentOptions.USE_TAB_CHARACTER);
        }
        Language language2 = language = content2 != null ? (Language)content2.getUserData(DiffUserDataKeys.LANGUAGE) : null;
        if (language != null) {
            editor.getSettings().setLanguageSupplier(() -> language);
        } else if (editor.getProject() != null) {
            editor.getSettings().setLanguageSupplier(() -> TextEditorImpl.getDocumentLanguage(editor));
        }
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor) {
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setAutoCodeFoldingEnabled(false);
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer) {
        return DiffUtil.createEditor(document, project, isViewer, false);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer, boolean enableFolding) {
        EditorFactory factory2 = EditorFactory.getInstance();
        EditorKind kind = EditorKind.DIFF;
        EditorEx editor = (EditorEx)(isViewer ? factory2.createViewer(document, project, kind) : factory2.createEditor(document, project, kind));
        editor.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        return editor;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content2, @Nullable Project project) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(content2.getDocument());
        if (virtualFile != null) {
            editor.setFile(virtualFile);
        }
        DiffUtil.setEditorHighlighter(project, editor, content2);
        DiffUtil.setEditorCodeStyle(project, editor, content2);
    }

    public static boolean isMirrored(@NotNull Editor editor) {
        if (editor instanceof EditorEx) {
            return ((EditorEx)editor).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean canNavigateToFile(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project == null || project.isDefault()) {
            return false;
        }
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        if (OutsidersPsiFileSupport.isOutsiderFile(file2)) {
            return false;
        }
        return file2.getUserData(TEMP_FILE_KEY) != Boolean.TRUE;
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull FoldingModelSupport foldingSupport) {
        assert (foldingSupport.getCount() == 1);
        TIntFunction foldingLineConvertor = foldingSupport.getLineConvertor(0);
        editor.getGutter().setLineNumberConverter((LineNumberConverter)new LineNumberConverterAdapter(foldingLineConvertor));
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull DocumentContent content2) {
        TIntFunction contentLineConvertor = DiffUtil.getContentLineConvertor(content2);
        editor.getGutter().setLineNumberConverter((LineNumberConverter)(contentLineConvertor == null ? LineNumberConverter.DEFAULT : new LineNumberConverterAdapter(contentLineConvertor)));
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull DocumentContent content2, @NotNull FoldingModelSupport foldingSupport, int editorIndex) {
        TIntFunction contentLineConvertor = DiffUtil.getContentLineConvertor(content2);
        TIntFunction foldingLineConvertor = foldingSupport.getLineConvertor(editorIndex);
        TIntFunction merged = DiffUtil.mergeLineConverters(contentLineConvertor, foldingLineConvertor);
        editor.getGutter().setLineNumberConverter((LineNumberConverter)(merged == null ? LineNumberConverter.DEFAULT : new LineNumberConverterAdapter(merged)));
    }

    @Nullable
    public static TIntFunction getContentLineConvertor(@NotNull DocumentContent content2) {
        return (TIntFunction)content2.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
    }

    @Nullable
    public static TIntFunction mergeLineConverters(@Nullable TIntFunction convertor1, @Nullable TIntFunction convertor2) {
        if (convertor1 == null && convertor2 == null) {
            return null;
        }
        if (convertor1 == null) {
            return convertor2;
        }
        if (convertor2 == null) {
            return convertor1;
        }
        return value2 -> {
            int value22 = convertor2.execute(value2);
            return value22 >= 0 ? convertor1.execute(value22) : value22;
        };
    }

    public static void disableBlitting(@NotNull EditorEx editor) {
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            editor.getScrollPane().getViewport().setScrollMode(0);
        }
    }

    public static void moveCaret(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor, int line, boolean animated) {
        DiffUtil.scrollEditor(editor, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column, boolean animated) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
        DiffUtil.scrollToCaret(editor, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            return new Point(0, 0);
        }
        ScrollingModel model = editor.getScrollingModel();
        return new Point(model.getHorizontalScrollOffset(), model.getVerticalScrollOffset());
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        return editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
    }

    public static void moveCaretToLineRangeIfNeeded(@NotNull Editor editor, int startLine, int endLine) {
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        if (!DiffUtil.isSelectedByLine(caretLine, startLine, endLine)) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(startLine, 0));
        }
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        return (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        return (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
    }

    public static boolean isFromShortcut(@NotNull AnActionEvent e) {
        String place = e.getPlace();
        return "keyboard shortcut".equals(place) || "mouse shortcut".equals(place);
    }

    public static void registerAction(@NotNull AnAction action2, @NotNull JComponent component2) {
        action2.registerCustomShortcutSet(action2.getShortcutSet(), component2);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull @Nls String message) {
        String text = StringUtil.replace((String)message, (String)"\n", (String)"<br>");
        JBLabel label2 = new JBLabel(text){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = Math.min(size.width, 200);
                size.height = Math.min(size.height, 100);
                return size;
            }
        }.setCopyable(true);
        return DiffUtil.createMessagePanel((JComponent)label2);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull JComponent label2) {
        JBColor commentFg = new JBColor(() -> {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes commentAttributes = scheme.getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT);
            if (commentAttributes.getForegroundColor() != null && commentAttributes.getBackgroundColor() == null) {
                return commentAttributes.getForegroundColor();
            }
            return scheme.getDefaultForeground();
        });
        label2.setForeground((Color)commentFg);
        JPanel panel2 = new JPanel((LayoutManager)new SingleComponentCenteringLayout());
        panel2.setBorder(JBUI.Borders.empty((int)5));
        panel2.setBackground((Color)new JBColor(() -> EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()));
        panel2.add(label2);
        return panel2;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions) {
        DiffUtil.addActionBlock(group, Arrays.asList(actions));
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        group.addSeparator();
        Object[] children2 = group.getChildren(null);
        for (AnAction anAction : actions) {
            if (!(anAction instanceof Separator) && ArrayUtil.contains((Object)anAction, (Object[])children2)) continue;
            group.add(anAction);
        }
    }

    @NotNull
    public static String getSettingsConfigurablePath() {
        return SystemInfo.isMac ? DiffBundle.message((String)"label.diff.settings.path.macos", (Object[])new Object[0]) : DiffBundle.message((String)"label.diff.settings.path", (Object[])new Object[0]);
    }

    @NotNull
    public static String createTooltipText(@NotNull @Nls String text, @Nullable @Nls String appendix) {
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><div style='margin-top: 5px'><font size='2'>");
            result2.append(appendix);
            result2.append("</font></div>");
        }
        result2.append("</body></html>");
        return result2.toString();
    }

    @NotNull
    public static String createNotificationText(@NotNull @Nls String text, @Nullable @Nls String appendix) {
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><span style='color:#").append(ColorUtil.toHex((Color)JBColor.gray)).append("'><small>");
            result2.append(appendix);
            result2.append("</small></span>");
        }
        result2.append("</body></html>");
        return result2.toString();
    }

    public static void showSuccessPopup(@NotNull String message, @NotNull RelativePoint point, @NotNull Disposable disposable2, final @Nullable Runnable hyperlinkHandler) {
        HyperlinkAdapter listener2 = null;
        if (hyperlinkHandler != null) {
            listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    hyperlinkHandler.run();
                }
            };
        }
        Color bgColor = MessageType.INFO.getPopupBackground();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, bgColor, (HyperlinkListener)listener2).setAnimationCycle(200).createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)disposable2, (Disposable)balloon);
    }

    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull ContentDiffRequest request2) {
        List contents = request2.getContents();
        List titles = request2.getContentTitles();
        if (!ContainerUtil.exists((Iterable)titles, (Condition)Conditions.notNull())) {
            return Collections.nCopies(titles.size(), null);
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        List diffTitleCustomizers = (List)request2.getUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER);
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i2))), diffTitleCustomizers != null ? (DiffEditorTitleCustomizer)diffTitleCustomizers.get(i2) : null);
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i2));
            components.add(title);
        }
        return components;
    }

    @NotNull
    public static List<JComponent> createTextTitles(@NotNull ContentDiffRequest request2, @NotNull List<? extends Editor> editors) {
        List contents = request2.getContents();
        List titles = request2.getContentTitles();
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        ArrayList<JComponent> result2 = new ArrayList<JComponent>(contents.size());
        if (equalCharsets && equalSeparators && !ContainerUtil.exists((Iterable)titles, (Condition)Conditions.notNull())) {
            return Collections.nCopies(titles.size(), null);
        }
        List diffTitleCustomizers = (List)request2.getUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER);
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i2))), (DiffContent)contents.get(i2), equalCharsets, equalSeparators, editors.get(i2), diffTitleCustomizers != null ? (DiffEditorTitleCustomizer)diffTitleCustomizers.get(i2) : null);
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i2));
            result2.add(title);
        }
        return result2;
    }

    @Nullable
    private static JComponent createTitleWithNotifications(@Nullable JComponent title, @NotNull DiffContent content2) {
        ArrayList<JComponent> notifications = new ArrayList<JComponent>(DiffUtil.getCustomNotifications(content2));
        if (content2 instanceof DocumentContent) {
            Document document = ((DocumentContent)content2).getDocument();
            if (FileDocumentManager.getInstance().isPartialPreviewOfALargeFile(document)) {
                notifications.add(DiffNotifications.createNotification(DiffBundle.message((String)"error.file.is.too.large.only.preview.is.loaded", (Object[])new Object[0])));
            }
        }
        if (notifications.isEmpty()) {
            return title;
        }
        JPanel panel2 = new JPanel(new BorderLayout(0, TITLE_GAP));
        if (title != null) {
            panel2.add((Component)title, "North");
        }
        panel2.add((Component)DiffUtil.createStackedComponents(notifications, TITLE_GAP), "South");
        return panel2;
    }

    @Nullable
    private static JComponent createTitle(@NotNull String title, @NotNull DiffContent content2, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor, @Nullable DiffEditorTitleCustomizer titleCustomizer) {
        if (content2 instanceof EmptyContent) {
            return null;
        }
        DocumentContent documentContent = (DocumentContent)content2;
        Charset charset = equalCharsets ? null : documentContent.getCharset();
        Boolean bom = equalCharsets ? null : documentContent.hasBom();
        LineSeparator separator = equalSeparators ? null : documentContent.getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(title, separator, charset, bom, isReadOnly, titleCustomizer);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title) {
        return DiffUtil.createTitle(title, null, null, null, false, null);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable DiffEditorTitleCustomizer titleCustomizer) {
        return DiffUtil.createTitle(title, null, null, null, false, titleCustomizer);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable LineSeparator separator, @Nullable Charset charset, @Nullable Boolean bom, boolean readOnly, @Nullable DiffEditorTitleCustomizer titleCustomizer) {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        BorderLayoutPanel labelWithIcon = new BorderLayoutPanel();
        JComponent titleLabel = titleCustomizer == null ? new JBLabel(title).setCopyable(true) : titleCustomizer.getLabel();
        labelWithIcon.addToCenter((Component)titleLabel);
        if (readOnly) {
            labelWithIcon.addToLeft((Component)new JBLabel(AllIcons.Ide.Readonly));
        }
        panel2.add((Component)labelWithIcon, "Center");
        if (charset != null || separator != null) {
            JPanel panel22 = new JPanel();
            panel22.setLayout(new BoxLayout(panel22, 0));
            if (charset != null) {
                panel22.add(Box.createRigidArea((Dimension)JBUI.size((int)4, (int)0)));
                panel22.add(DiffUtil.createCharsetPanel(charset, bom));
            }
            if (separator != null) {
                panel22.add(Box.createRigidArea((Dimension)JBUI.size((int)4, (int)0)));
                panel22.add(DiffUtil.createSeparatorPanel(separator));
            }
            panel2.add((Component)panel22, "East");
        }
        return panel2;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset, @Nullable Boolean bom) {
        String text = charset.displayName();
        if (bom != null && bom.booleanValue()) {
            text = text + " BOM";
        }
        JLabel label2 = new JLabel(text);
        if (charset.equals(StandardCharsets.UTF_8)) {
            label2.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(StandardCharsets.ISO_8859_1)) {
            label2.setForeground((Color)JBColor.RED);
        } else {
            label2.setForeground((Color)JBColor.BLACK);
        }
        return label2;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        JLabel label2 = new JLabel(separator.name());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label2.setForeground((Color)color);
        return label2;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (!ContainerUtil.exists(components, (Condition)Conditions.notNull())) {
            return components;
        }
        ArrayList<JComponent> result2 = new ArrayList<JComponent>();
        for (int i2 = 0; i2 < components.size(); ++i2) {
            result2.add(new SyncHeightComponent(components, i2));
        }
        return result2;
    }

    @NotNull
    public static JComponent createStackedComponents(@NotNull List<? extends JComponent> components, int gap) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        for (int i2 = 0; i2 < components.size(); ++i2) {
            if (i2 != 0) {
                panel2.add(Box.createVerticalStrut(JBUIScale.scale((int)gap)));
            }
            panel2.add(components.get(i2));
        }
        return panel2;
    }

    @NotNull
    public static String getStatusText(int totalCount, int excludedCount, @NotNull ThreeState isContentsEqual) {
        if (totalCount == 0 && isContentsEqual == ThreeState.NO) {
            return DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
        }
        String message = DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{totalCount - excludedCount});
        if (excludedCount > 0) {
            message = message + " " + DiffBundle.message((String)"diff.inactive.count.differences.status.text", (Object[])new Object[]{excludedCount});
        }
        return message;
    }

    public static boolean isFocusedComponent(@Nullable Component component2) {
        return DiffUtil.isFocusedComponent(null, component2);
    }

    public static boolean isFocusedComponent(@Nullable Project project, @Nullable Component component2) {
        if (component2 == null) {
            return false;
        }
        Component ideFocusOwner = IdeFocusManager.getInstance((Project)project).getFocusOwner();
        if (ideFocusOwner != null && SwingUtilities.isDescendingFrom(ideFocusOwner, component2)) {
            return true;
        }
        Component jdkFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return jdkFocusOwner != null && SwingUtilities.isDescendingFrom(jdkFocusOwner, component2);
    }

    public static void requestFocus(@Nullable Project project, @Nullable Component component2) {
        if (component2 == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project).requestFocus(component2, true);
    }

    public static boolean isFocusedComponentInWindow(@Nullable Component component2) {
        if (component2 == null) {
            return false;
        }
        Window window = ComponentUtil.getWindow((Component)component2);
        if (window == null) {
            return false;
        }
        Component windowFocusOwner = window.getMostRecentFocusOwner();
        return windowFocusOwner != null && SwingUtilities.isDescendingFrom(windowFocusOwner, component2);
    }

    public static void requestFocusInWindow(@Nullable Component component2) {
        if (component2 != null) {
            component2.requestFocusInWindow();
        }
    }

    public static void runPreservingFocus(@NotNull FocusableContext context, @NotNull Runnable task2) {
        boolean hadFocus = context.isFocusedInWindow();
        task2.run();
        if (hadFocus) {
            context.requestFocusInWindow();
        }
    }

    @NotNull
    public static TwosideTextDiffProvider createTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2) {
        DiffUserDataKeysEx.DiffComputer diffComputer = (DiffUserDataKeysEx.DiffComputer)request2.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER);
        if (diffComputer != null) {
            return new SimpleTextDiffProvider(settings, rediff, disposable2, diffComputer);
        }
        TwosideTextDiffProvider smartProvider = SmartTextDiffProvider.create(project, request2, settings, rediff, disposable2);
        if (smartProvider != null) {
            return smartProvider;
        }
        return new SimpleTextDiffProvider(settings, rediff, disposable2);
    }

    @NotNull
    public static TwosideTextDiffProvider.NoIgnore createNoIgnoreTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2) {
        DiffUserDataKeysEx.DiffComputer diffComputer = (DiffUserDataKeysEx.DiffComputer)request2.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER);
        if (diffComputer != null) {
            return new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable2, diffComputer);
        }
        TwosideTextDiffProvider.NoIgnore smartProvider = SmartTextDiffProvider.createNoIgnore(project, request2, settings, rediff, disposable2);
        if (smartProvider != null) {
            return smartProvider;
        }
        return new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable2);
    }

    @Nullable
    public static MergeInnerDifferences compareThreesideInner(@NotNull List<? extends CharSequence> chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator) {
        if (chunks.get(0) == null && chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(1), comparisonPolicy) && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(2), comparisonPolicy)) {
            return new MergeInnerDifferences(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (chunks.get(0) == null && chunks.get(1) == null || chunks.get(0) == null && chunks.get(2) == null || chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (chunks.get(0) != null && chunks.get(1) != null && chunks.get(2) != null) {
            List<DiffFragment> fragments1 = ByWord.compare(chunks.get(1), chunks.get(0), comparisonPolicy, indicator);
            List<DiffFragment> fragments2 = ByWord.compare(chunks.get(1), chunks.get(2), comparisonPolicy, indicator);
            ArrayList<TextRange> left = new ArrayList<TextRange>();
            ArrayList<TextRange> base = new ArrayList<TextRange>();
            ArrayList<TextRange> right = new ArrayList<TextRange>();
            for (DiffFragment wordFragment : fragments1) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                left.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            for (DiffFragment wordFragment : fragments2) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                right.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            return new MergeInnerDifferences(left, base, right);
        }
        ThreeSide side1 = chunks.get(0) != null ? ThreeSide.LEFT : ThreeSide.BASE;
        ThreeSide side2 = chunks.get(2) != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select(chunks);
        CharSequence chunk2 = (CharSequence)side2.select(chunks);
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator);
        List textRanges = ThreeSide.map(side -> {
            if (side == side1) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()));
            }
            if (side == side2) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset2(), fragment.getEndOffset2()));
            }
            return null;
        });
        return new MergeInnerDifferences((List)textRanges.get(0), (List)textRanges.get(1), (List)textRanges.get(2));
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonUtil.isEquals(chunk1, chunk2, comparisonPolicy);
    }

    public static <T> int @NotNull [] getSortedIndexes(@NotNull List<? extends T> values2, @NotNull Comparator<? super T> comparator2) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(values2.size());
        for (int i3 = 0; i3 < values2.size(); ++i3) {
            indexes.add(i3);
        }
        ContainerUtil.sort(indexes, (i1, i2) -> {
            Object val1 = values2.get((int)i1);
            Object val2 = values2.get((int)i2);
            return comparator2.compare((Object)val1, (Object)val2);
        });
        return ArrayUtil.toIntArray(indexes);
    }

    public static int @NotNull [] invertIndexes(int @NotNull [] indexes) {
        int[] inverted = new int[indexes.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            inverted[indexes[i2]] = i2;
        }
        return inverted;
    }

    /*
     * Exception decompiling
     */
    public static boolean compareStreams(@NotNull ThrowableComputable<? extends InputStream, ? extends IOException> stream1, @NotNull ThrowableComputable<? extends InputStream, ? extends IOException> stream2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [37[UNCONDITIONALDOLOOP]], but top level block is 18[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static InputStream getFileInputStream(@NotNull VirtualFile file2) throws IOException {
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof FileSystemInterface) {
            return ((FileSystemInterface)fs).getInputStream(file2);
        }
        byte[] content2 = (byte[])ReadAction.compute(() -> file2.contentsToByteArray());
        return new ByteArrayInputStream(content2);
    }

    public static boolean isSomeRangeSelected(@NotNull Editor editor, @NotNull Condition<? super BitSet> condition) {
        List carets = editor.getCaretModel().getAllCarets();
        if (carets.size() != 1) {
            return true;
        }
        Caret caret = (Caret)carets.get(0);
        if (caret.hasSelection()) {
            return true;
        }
        return condition.value((Object)DiffUtil.getSelectedLines(editor));
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines = new BitSet(totalLines + 1);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            DiffUtil.appendSelectedLines(editor, lines, caret);
        }
        return lines;
    }

    private static void appendSelectedLines(@NotNull Editor editor, @NotNull BitSet lines, @NotNull Caret caret) {
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        if (caret.hasSelection()) {
            int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
            int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
            lines.set(line1, line2 + 1);
            if (caret.getSelectionEnd() == document.getTextLength()) {
                lines.set(totalLines);
            }
        } else {
            int offset = caret.getOffset();
            VisualPosition visualPosition = caret.getVisualPosition();
            Pair<LogicalPosition, LogicalPosition> pair = EditorUtil.calcSurroundingRange(editor, visualPosition, visualPosition);
            lines.set(((LogicalPosition)pair.first).line, Math.max(((LogicalPosition)pair.second).line, ((LogicalPosition)pair.first).line + 1));
            if (offset == document.getTextLength()) {
                lines.set(totalLines);
            }
        }
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected2, int line1, int line2) {
        if (line1 == line2) {
            return selected2.get(line1);
        }
        int next = selected2.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    private static void deleteLines(@NotNull Document document, int line1, int line2) {
        TextRange range2 = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range2.getStartOffset();
        int offset2 = range2.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    private static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text) {
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + text));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(text + "\n"));
        }
    }

    private static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text) {
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text);
    }

    public static void applyModification(@NotNull Document document, int line1, int line2, @NotNull List<? extends CharSequence> newLines) {
        if (line1 == line2 && newLines.isEmpty()) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document, line1, StringUtil.join(newLines, (String)"\n"));
        } else if (newLines.isEmpty()) {
            DiffUtil.deleteLines(document, line1, line2);
        } else {
            DiffUtil.replaceLines(document, line1, line2, StringUtil.join(newLines, (String)"\n"));
        }
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        }
    }

    public static String applyModification(final @NotNull CharSequence text, final @NotNull LineOffsets lineOffsets, final @NotNull CharSequence otherText, final @NotNull LineOffsets otherLineOffsets, final @NotNull List<? extends Range> ranges) {
        return new Object(){
            private final StringBuilder stringBuilder = new StringBuilder();
            private boolean isEmpty = true;

            @NotNull
            public String execute() {
                int lastLine = 0;
                for (Range range2 : ranges) {
                    CharSequence newChunkContent = DiffUtil.getLinesContent(otherText, otherLineOffsets, range2.start2, range2.end2);
                    this.appendOriginal(lastLine, range2.start1);
                    this.append(newChunkContent, range2.end2 - range2.start2);
                    lastLine = range2.end1;
                }
                this.appendOriginal(lastLine, lineOffsets.getLineCount());
                return this.stringBuilder.toString();
            }

            private void appendOriginal(int start2, int end) {
                this.append(DiffUtil.getLinesContent(text, lineOffsets, start2, end), end - start2);
            }

            private void append(CharSequence content2, int lineCount) {
                if (lineCount > 0 && !this.isEmpty) {
                    this.stringBuilder.append('\n');
                }
                this.stringBuilder.append(content2);
                this.isEmpty &= lineCount == 0;
            }
        }.execute();
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        return DiffUtil.getLinesRange(document, line1, line2).subSequence(document.getImmutableCharSequence());
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2, boolean includeNewLine) {
        return DiffUtil.getLinesRange(document, line1, line2, includeNewLine).subSequence(document.getImmutableCharSequence());
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2) {
        return DiffUtil.getLinesContent(sequence, lineOffsets, line1, line2, false);
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        assert (sequence.length() == lineOffsets.getTextLength());
        return DiffUtil.getLinesRange(lineOffsets, line1, line2, includeNewline).subSequence(sequence);
    }

    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        return DiffUtil.getLinesRange(document, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2, boolean includeNewline) {
        return DiffUtil.getLinesRange(LineOffsetsUtil.create(document), line1, line2, includeNewline);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (line1 == line2) {
            int lineStartOffset = line1 < lineOffsets.getLineCount() ? lineOffsets.getLineStart(line1) : lineOffsets.getTextLength();
            return new TextRange(lineStartOffset, lineStartOffset);
        }
        int startOffset = lineOffsets.getLineStart(line1);
        int endOffset = lineOffsets.getLineEnd(line2 - 1);
        if (includeNewline && endOffset < lineOffsets.getTextLength()) {
            ++endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getOffset(@NotNull Document document, int line, int column) {
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document)) {
            return document.getTextLength();
        }
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        return Math.min(start2 + column, end);
    }

    public static int getLineCount(@NotNull Document document) {
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document) {
        return DiffUtil.getLines(document, 0, DiffUtil.getLineCount(document));
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text, @NonNls LineOffsets lineOffsets) {
        return DiffUtil.getLines(text, lineOffsets, 0, lineOffsets.getLineCount());
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document, int startLine, int endLine) {
        return DiffUtil.getLines(document.getCharsSequence(), LineOffsetsUtil.create(document), startLine, endLine);
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text, @NonNls LineOffsets lineOffsets, int startLine, int endLine) {
        if (startLine < 0 || startLine > endLine || endLine > lineOffsets.getLineCount()) {
            throw new IndexOutOfBoundsException(String.format("Wrong line range: [%d, %d); lineCount: '%d'", startLine, endLine, lineOffsets.getLineCount()));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i2 = startLine; i2 < endLine; ++i2) {
            int start2 = lineOffsets.getLineStart(i2);
            int end = lineOffsets.getLineEnd(i2);
            result2.add(text.subSequence(start2, end).toString());
        }
        return result2;
    }

    public static int bound(int value2, int lowerBound, int upperBound) {
        assert (lowerBound <= upperBound) : String.format("%s - [%s, %s]", value2, lowerBound, upperBound);
        return MathUtil.clamp((int)value2, (int)lowerBound, (int)upperBound);
    }

    @NotNull
    public static LineRange getAffectedLineRange(@NotNull DocumentEvent e) {
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        return new LineRange(line1, line2);
    }

    public static int countLinesShift(@NotNull DocumentEvent e) {
        return StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start2, int end, int changeStart, int changeEnd, int shift) {
        return DiffUtil.updateRangeOnModification(start2, end, changeStart, changeEnd, shift, false);
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start2, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            return new UpdatedLineRange(start2, end, false);
        }
        if (start2 >= changeEnd) {
            return new UpdatedLineRange(start2 + shift, end + shift, false);
        }
        if (start2 <= changeStart && end >= changeEnd) {
            return new UpdatedLineRange(start2, end + shift, false);
        }
        int newChangeEnd = changeEnd + shift;
        if (start2 >= changeStart && end <= changeEnd) {
            return greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
        }
        if (start2 < changeStart) {
            return greedy ? new UpdatedLineRange(start2, newChangeEnd, true) : new UpdatedLineRange(start2, changeStart, true);
        }
        return greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        boolean left = fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getStartLine2() != fragment.getEndLine2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(boolean hasDeleted, boolean hasInserted) {
        if (hasDeleted && hasInserted) {
            return TextDiffType.MODIFIED;
        }
        if (hasDeleted) {
            return TextDiffType.DELETED;
        }
        if (hasInserted) {
            return TextDiffType.INSERTED;
        }
        LOG.error("Diff fragment should not be empty");
        return TextDiffType.MODIFIED;
    }

    @NotNull
    public static MergeConflictType getMergeType(@NotNull Condition<? super ThreeSide> emptiness, @NotNull Equality<? super ThreeSide> equality, @Nullable Equality<? super ThreeSide> trueEquality, @NotNull BooleanGetter conflictResolver) {
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(TextDiffType.INSERTED, false, true);
            }
            if (isRightEmpty) {
                return new MergeConflictType(TextDiffType.INSERTED, true, false);
            }
            boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            if (equalModifications) {
                return new MergeConflictType(TextDiffType.INSERTED, true, true);
            }
            return new MergeConflictType(TextDiffType.CONFLICT, true, true, false);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(TextDiffType.DELETED, true, true);
        }
        boolean unchangedLeft = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
        boolean unchangedRight = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
        if (unchangedLeft && unchangedRight) {
            assert (trueEquality != null);
            boolean trueUnchangedLeft = trueEquality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
            boolean trueUnchangedRight = trueEquality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            assert (!trueUnchangedLeft || !trueUnchangedRight);
            return new MergeConflictType(TextDiffType.MODIFIED, !trueUnchangedLeft, !trueUnchangedRight);
        }
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
        }
        boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        if (equalModifications) {
            return new MergeConflictType(TextDiffType.MODIFIED, true, true);
        }
        boolean canBeResolved = !isLeftEmpty && !isRightEmpty && conflictResolver.get();
        return new MergeConflictType(TextDiffType.CONFLICT, true, true, canBeResolved);
    }

    @NotNull
    public static MergeConflictType getLineThreeWayDiffType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        return DiffUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> DiffUtil.isLineMergeIntervalEmpty(fragment, side)), (Equality<? super ThreeSide>)((Equality)(side1, side2) -> DiffUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2)), null, () -> DiffUtil.canResolveLineConflict(fragment, sequences, lineOffsets));
    }

    @NotNull
    public static MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        return DiffUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> DiffUtil.isLineMergeIntervalEmpty(fragment, side)), (Equality<? super ThreeSide>)((Equality)(side1, side2) -> DiffUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2)), (Equality<? super ThreeSide>)((Equality)(side1, side2) -> DiffUtil.compareLineMergeContents(fragment, sequences, lineOffsets, ComparisonPolicy.DEFAULT, side1, side2)), () -> DiffUtil.canResolveLineConflict(fragment, sequences, lineOffsets));
    }

    private static boolean canResolveLineConflict(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets) {
        List contents = ThreeSide.map(side -> DiffUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), fragment.getStartLine(side), fragment.getEndLine(side)));
        return ComparisonMergeUtil.tryResolveConflict((CharSequence)contents.get(0), (CharSequence)contents.get(1), (CharSequence)contents.get(2)) != null;
    }

    private static boolean compareLineMergeContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        CharSequence sequence1 = (CharSequence)side1.select(sequences);
        CharSequence sequence2 = (CharSequence)side2.select(sequences);
        LineOffsets offsets1 = (LineOffsets)side1.select(lineOffsets);
        LineOffsets offsets2 = (LineOffsets)side2.select(lineOffsets);
        for (int i2 = 0; i2 < end1 - start1; ++i2) {
            CharSequence content2;
            int line1 = start1 + i2;
            int line2 = start2 + i2;
            CharSequence content1 = DiffUtil.getLinesContent(sequence1, offsets1, line1, line1 + 1);
            if (ComparisonUtil.isEquals(content1, content2 = DiffUtil.getLinesContent(sequence2, offsets2, line2, line2 + 1), policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineMergeIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    @NotNull
    public static MergeConflictType getWordMergeType(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy) {
        return DiffUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> DiffUtil.isWordMergeIntervalEmpty(fragment, side)), (Equality<? super ThreeSide>)((Equality)(side1, side2) -> DiffUtil.compareWordMergeContents(fragment, texts, policy, side1, side2)), null, BooleanGetter.FALSE);
    }

    public static boolean compareWordMergeContents(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        int start1 = fragment.getStartOffset(side1);
        int end1 = fragment.getEndOffset(side1);
        int start2 = fragment.getStartOffset(side2);
        int end2 = fragment.getEndOffset(side2);
        CharSequence document1 = (CharSequence)side1.select(texts);
        CharSequence document2 = (CharSequence)side2.select(texts);
        CharSequence content1 = document1.subSequence(start1, end1);
        CharSequence content2 = document2.subSequence(start2, end2);
        return ComparisonUtil.isEquals(content1, content2, policy);
    }

    private static boolean isWordMergeIntervalEmpty(@NotNull MergeWordFragment fragment, @NotNull ThreeSide side) {
        return fragment.getStartOffset(side) == fragment.getEndOffset(side);
    }

    public static boolean executeWriteCommand(@Nullable Project project, @NotNull Document document, @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @NotNull Runnable task2) {
        if (!DiffUtil.makeWritable(project, document)) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            LOG.warn("Document is read-only" + (file2 != null ? ": " + file2.getPresentableName() : ""));
            return false;
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
            if (underBulkUpdate) {
                DocumentUtil.executeInBulk(document, true, task2);
            } else {
                task2.run();
            }
        }, commandName, (Object)commandGroupId, confirmationPolicy, document));
        return true;
    }

    public static boolean executeWriteCommand(@NotNull Document document, @Nullable Project project, @Nullable @Nls String commandName, @NotNull Runnable task2) {
        return DiffUtil.executeWriteCommand(project, document, commandName, null, UndoConfirmationPolicy.DEFAULT, false, task2);
    }

    public static boolean isEditable(@NotNull Editor editor) {
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.isValid() && file2.isInLocalFileSystem()) {
            if (file2.getUserData(TEMP_FILE_KEY) == Boolean.TRUE) {
                return false;
            }
            return !file2.isWritable();
        }
        return false;
    }

    public static boolean makeWritable(@Nullable Project project, @NotNull Document document) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return document.isWritable();
        }
        if (!file2.isValid()) {
            return false;
        }
        return DiffUtil.makeWritable(project, file2) && document.isWritable();
    }

    public static boolean makeWritable(@Nullable Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(file2)).hasReadonlyFiles();
    }

    public static void putNonundoableOperation(@Nullable Project project, @NotNull Document document) {
        UndoManager undoManager;
        UndoManager undoManager2 = undoManager = project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
        if (undoManager != null) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            undoManager.nonundoableActionPerformed(ref, false);
        }
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files2) {
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files2);
        RefreshQueue.getInstance().refresh(async, recursive, null, modalityState, files2);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        return new Dimension(400, 200);
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        return new Dimension(width, height);
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints2) {
        WindowWrapper.Mode mode = hints2.getMode();
        if (mode == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        return mode;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        boolean isClosed;
        if (window == null) {
            return;
        }
        Container component2 = window;
        while (component2 != null && (!(component2 instanceof Window) || (isClosed = DiffUtil.closeWindow(component2, modalOnly)))) {
            component2 = recursive ? component2.getParent() : null;
        }
    }

    private static boolean closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window instanceof IdeFrameImpl || modalOnly && DiffUtil.canBeHiddenBehind(window)) {
            return false;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return !window.isVisible();
        }
        window.setVisible(false);
        window.dispose();
        return true;
    }

    private static boolean canBeHiddenBehind(@NotNull Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        if (SystemInfo.isMac && window instanceof IdeFrame) {
            Project project = ((IdeFrame)window).getProject();
            IdeFrame projectFrame = WindowManager.getInstance().getIdeFrame(project);
            if (projectFrame != null) {
                return !projectFrame.isInFullScreen();
            }
        }
        return true;
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key, @Nullable T value2) {
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key, value2);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key, UserDataHolder ... holders) {
        for (UserDataHolder holder : holders) {
            Boolean data2;
            if (holder == null || (data2 = (Boolean)holder.getUserData(key)) == null) continue;
            return data2;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key) {
        Object data2;
        if (first != null && (data2 = first.getUserData(key)) != null) {
            return (T)data2;
        }
        if (second != null && (data2 = second.getUserData(key)) != null) {
            return (T)data2;
        }
        return null;
    }

    public static void addNotification(@Nullable JComponent component2, @NotNull UserDataHolder holder) {
        if (component2 == null) {
            return;
        }
        List oldComponents = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        holder.putUserData(DiffUserDataKeys.NOTIFICATIONS, (Object)ContainerUtil.append((List)oldComponents, (Object[])new JComponent[]{component2}));
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull UserDataHolder context, @NotNull UserDataHolder request2) {
        List requestComponents = (List)request2.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List contextComponents = (List)context.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        return ContainerUtil.concat((List)ContainerUtil.notNullize((List)contextComponents), (List)ContainerUtil.notNullize((List)requestComponents));
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContent content2) {
        return ContainerUtil.notNullize((List)((List)content2.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
    }

    @Nullable
    public static Object getData(@Nullable DataProvider provider, @Nullable DataProvider fallbackProvider, @NotNull @NonNls String dataId) {
        Object data2;
        if (provider != null && (data2 = provider.getData(dataId)) != null) {
            return data2;
        }
        if (fallbackProvider != null && (data2 = fallbackProvider.getData(dataId)) != null) {
            return data2;
        }
        return null;
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key, @Nullable T value2) {
        DataProvider dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER);
        if (!(dataProvider instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key, value2);
    }

    @NotNull
    public static DiffSettingsHolder.DiffSettings getDiffSettings(@NotNull DiffContext context) {
        DiffSettingsHolder.DiffSettings settings = (DiffSettingsHolder.DiffSettings)context.getUserData(DiffSettingsHolder.DiffSettings.KEY);
        if (settings == null) {
            settings = DiffSettingsHolder.DiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(DiffSettingsHolder.DiffSettings.KEY, (Object)settings);
        }
        return settings;
    }

    @NotNull
    public static <K, V> TreeMap<K, V> trimDefaultValues(@NotNull TreeMap<K, V> map2, @NotNull Convertor<? super K, V> defaultValue) {
        TreeMap<K, V> result2 = new TreeMap<K, V>();
        for (Map.Entry<K, V> it : map2.entrySet()) {
            K key = it.getKey();
            V value2 = it.getValue();
            if (value2.equals(defaultValue.convert(key))) continue;
            result2.put(key, value2);
        }
        return result2;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools.size() < 2) {
            return tools;
        }
        ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool2 : tools) {
            try {
                if (!(tool2 instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool2).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            return tools;
        }
        List filteredTools = ContainerUtil.filter(tools, tool -> !suppressedTools.contains(tool.getClass()));
        return filteredTools.isEmpty() ? tools : filteredTools;
    }

    @Nullable
    public static DiffTool findToolSubstitutor(@NotNull DiffTool tool, @NotNull DiffContext context, @NotNull DiffRequest request2) {
        for (DiffToolSubstitutor substitutor : (DiffToolSubstitutor[])DiffToolSubstitutor.EP_NAME.getExtensions()) {
            DiffTool replacement = substitutor.getReplacement(tool, context, request2);
            if (replacement == null) continue;
            boolean canShow = replacement.canShow(context, request2);
            if (!canShow) {
                LOG.error("DiffTool substitutor returns invalid tool");
                continue;
            }
            return replacement;
        }
        return null;
    }

    static /* synthetic */ List access$000() {
        return DiffUtil.loadDiffFrameImages();
    }

    private static class SyncHeightComponent
    extends JPanel {
        @NotNull
        private final List<? extends JComponent> myComponents;

        SyncHeightComponent(@NotNull List<? extends JComponent> components, int index) {
            super(new BorderLayout());
            this.myComponents = components;
            JComponent delegate = components.get(index);
            if (delegate != null) {
                this.add((Component)delegate, "Center");
            }
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.height = this.getMaximumHeight((Function<JComponent, Dimension>)((Function)JComponent::getMinimumSize));
            return size;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = this.getMaximumHeight((Function<JComponent, Dimension>)((Function)JComponent::getPreferredSize));
            return size;
        }

        private int getMaximumHeight(@NotNull Function<JComponent, Dimension> getter) {
            int height = 0;
            for (JComponent jComponent : this.myComponents) {
                if (jComponent == null) continue;
                height = Math.max(height, ((Dimension)getter.fun((Object)jComponent)).height);
            }
            return height;
        }
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }

    public static final class Lazy {
        public static final List<Image> DIFF_FRAME_ICONS = DiffUtil.access$000();
    }
}

