/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffGutterOperation {
    @NotNull
    private final RangeHighlighter myHighlighter;

    public DiffGutterOperation(@NotNull Editor editor, int offset) {
        this.myHighlighter = editor.getMarkupModel().addRangeHighlighter(null, offset, offset, 3000, HighlighterTargetArea.LINES_IN_RANGE);
    }

    public void dispose() {
        this.myHighlighter.dispose();
    }

    public void update(boolean force) {
        if (!this.myHighlighter.isValid()) {
            return;
        }
        this.myHighlighter.setGutterIconRenderer(this.createRenderer());
    }

    protected abstract GutterIconRenderer createRenderer();

    public static int lineToOffset(@NotNull Editor editor, int line) {
        Document document = editor.getDocument();
        return line == DiffUtil.getLineCount(document) ? document.getTextLength() : document.getLineStartOffset(line);
    }

    public static interface ModifiersRendererBuilder {
        @Nullable
        public GutterIconRenderer createRenderer(boolean var1, boolean var2, boolean var3);
    }

    public static interface RendererBuilder {
        @Nullable
        public GutterIconRenderer createRenderer();
    }

    public static final class WithModifiers
    extends DiffGutterOperation {
        @NotNull
        private final ModifiersRendererBuilder myBuilder;
        @NotNull
        private final KeyboardModifierListener myModifierProvider;
        private boolean myCtrlPressed;
        private boolean myShiftPressed;
        private boolean myAltPressed;

        public WithModifiers(@NotNull Editor editor, int offset, @NotNull KeyboardModifierListener modifierProvider, @NotNull ModifiersRendererBuilder builder2) {
            super(editor, offset);
            this.myBuilder = builder2;
            this.myModifierProvider = modifierProvider;
            this.update(true);
        }

        @Override
        public void update(boolean force) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = force || this.myCtrlPressed == this.myModifierProvider.isCtrlPressed() || this.myShiftPressed == this.myModifierProvider.isShiftPressed() || this.myAltPressed == this.myModifierProvider.isAltPressed();
            if (!shouldUpdate) {
                return;
            }
            this.myCtrlPressed = this.myModifierProvider.isCtrlPressed();
            this.myShiftPressed = this.myModifierProvider.isShiftPressed();
            this.myAltPressed = this.myModifierProvider.isAltPressed();
            super.update(force);
        }

        @Override
        protected GutterIconRenderer createRenderer() {
            return this.myBuilder.createRenderer(this.myCtrlPressed, this.myShiftPressed, this.myAltPressed);
        }
    }

    public static final class Simple
    extends DiffGutterOperation {
        @NotNull
        private final RendererBuilder myBuilder;

        public Simple(@NotNull Editor editor, int offset, @NotNull RendererBuilder builder2) {
            super(editor, offset);
            this.myBuilder = builder2;
            this.update(true);
        }

        @Override
        protected GutterIconRenderer createRenderer() {
            return this.myBuilder.createRenderer();
        }
    }
}

