/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffDividerDrawUtil {
    public static final BasicStroke BOLD_DOTTED_STROKE = new BasicStroke(2.3f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

    @NotNull
    public static Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider, @NotNull Component base) {
        int width = divider.getWidth();
        int editorHeight = base.getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = base.getLocationOnScreen().y;
        return (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
    }

    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerSeparator polygon : polygons) {
            polygon.paint(gg, width);
        }
        config2.restore();
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        DiffDividerDrawUtil.paintPolygons(gg, width, true, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean curved, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width, curved);
        }
        config2.restore();
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(final @NotNull Editor editor1, final @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        final ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        final LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        final LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DividerPaintable.Handler(){

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
                if (leftInterval.start > endLine1 && rightInterval.start > endLine2) {
                    return true;
                }
                if (leftInterval.end < startLine1 && rightInterval.end < startLine2) {
                    return false;
                }
                if (DiffDividerDrawUtil.isIntervalVisible(editor1, startLine1, endLine1) || DiffDividerDrawUtil.isIntervalVisible(editor2, startLine2, endLine2)) {
                    polygons.add(DiffDividerDrawUtil.createPolygon(editor1, editor2, startLine1, endLine1, startLine2, endLine2, fillColor, borderColor, dottedBorder));
                }
                return true;
            }
        });
        return polygons;
    }

    private static boolean isIntervalVisible(@NotNull Editor editor, int startLine, int endLine) {
        TextRange range2 = DiffUtil.getLinesRange(editor.getDocument(), startLine, endLine);
        return !FoldingUtil.isTextRangeFolded(editor, range2);
    }

    @NotNull
    public static List<DividerSeparator> createVisibleSeparators(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        ArrayList<DividerSeparator> separators = new ArrayList<DividerSeparator>();
        LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        int height1 = editor1.getLineHeight();
        int height2 = editor2.getLineHeight();
        EditorColorsScheme scheme = editor1.getColorsScheme();
        paintable.process((line1, line2) -> {
            if (leftInterval.start > line1 + 1 && rightInterval.start > line2 + 1) {
                return true;
            }
            if (leftInterval.end < line1 && rightInterval.end < line2) {
                return false;
            }
            separators.add(DiffDividerDrawUtil.createSeparator(editor1, editor2, line1, line2, height1, height2, scheme));
            return true;
        });
        return separators;
    }

    private static int getEditorTopOffset(@NotNull Editor editor) {
        JComponent header2 = editor.getHeaderComponent();
        int headerOffset = header2 == null ? 0 : header2.getHeight();
        return -editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Editor editor1, @NotNull Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
        int topOffset1 = DiffDividerDrawUtil.getEditorTopOffset(editor1);
        int topOffset2 = DiffDividerDrawUtil.getEditorTopOffset(editor2);
        DiffDrawUtil.MarkerRange range1 = DiffDrawUtil.getGutterMarkerPaintRange(editor1, startLine1, endLine1);
        DiffDrawUtil.MarkerRange range2 = DiffDrawUtil.getGutterMarkerPaintRange(editor2, startLine2, endLine2);
        return new DividerPolygon(range1.y1 + topOffset1, range2.y1 + topOffset2, range1.y2 + topOffset1, range2.y2 + topOffset2, fillColor, borderColor, dottedBorder);
    }

    @NotNull
    private static DividerSeparator createSeparator(@NotNull Editor editor1, @NotNull Editor editor2, int line1, int line2, int height1, int height2, @Nullable EditorColorsScheme scheme) {
        int topOffset1 = DiffDividerDrawUtil.getEditorTopOffset(editor1);
        int topOffset2 = DiffDividerDrawUtil.getEditorTopOffset(editor2);
        int start1 = DiffDrawUtil.lineToY(editor1, line1) + topOffset1;
        int start2 = DiffDrawUtil.lineToY(editor2, line2) + topOffset2;
        return new DividerSeparator(start1, start2, start1 + height1, start2 + height2, scheme);
    }

    @NotNull
    private static LineRange getVisibleInterval(Editor editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        if (area.height < 0) {
            return new LineRange(0, 0);
        }
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        return new LineRange(position1.line, position2.line);
    }

    public static class DividerSeparator {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final EditorColorsScheme myScheme;

        public DividerSeparator(int start1, int start2, int end1, int end2, @Nullable EditorColorsScheme scheme) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myScheme = scheme;
        }

        public void paint(Graphics2D g, int width) {
            DiffLineSeparatorRenderer.drawConnectorLine(g, 0, width, this.myStart1, this.myStart2, this.myEnd1 - this.myStart1, this.myScheme);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> ";
        }
    }

    public static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final Color myFillColor;
        @Nullable
        private final Color myBorderColor;
        private final boolean myDottedBorder;

        public DividerPolygon(int start1, int start2, int end1, int end2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myFillColor = fillColor;
            this.myBorderColor = borderColor;
            this.myDottedBorder = dottedBorder;
        }

        public void paint(Graphics2D g, int width, boolean curve) {
            int endY2;
            int startY2;
            int endY1;
            int startY1;
            if (this.myEnd1 - this.myStart1 < 2) {
                startY1 = this.myStart1 - 1;
                endY1 = this.myStart1;
            } else {
                startY1 = this.myStart1;
                endY1 = this.myEnd1 - 1;
            }
            if (this.myEnd2 - this.myStart2 < 2) {
                startY2 = this.myStart2 - 1;
                endY2 = this.myStart2;
            } else {
                startY2 = this.myStart2;
                endY2 = this.myEnd2 - 1;
            }
            Stroke oldStroke = g.getStroke();
            if (this.myDottedBorder) {
                g.setStroke(BOLD_DOTTED_STROKE);
            }
            if (curve) {
                DiffDrawUtil.drawCurveTrapezium(g, 0, width, startY1, endY1, startY2, endY2, this.myFillColor, this.myBorderColor);
            } else {
                DiffDrawUtil.drawTrapezium(g, 0, width, startY1, endY1, startY2, endY2, this.myFillColor, this.myBorderColor);
            }
            g.setStroke(oldStroke);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myFillColor + ", " + this.myBorderColor;
        }
    }

    public static interface DividerSeparatorPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2);
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static abstract class Handler {
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                return this.process(startLine1, endLine1, startLine2, endLine2, color, null, false);
            }

            public boolean processResolvable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Editor editor, @NotNull TextDiffType type, boolean resolved) {
                Color color = type.getColor(editor);
                return this.process(startLine1, endLine1, startLine2, endLine2, resolved ? null : color, resolved ? color : null, resolved);
            }

            public boolean processExcludable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Editor editor, @NotNull TextDiffType type, boolean excluded) {
                Color borderColor = excluded ? type.getColor(editor) : null;
                Color fillColor = excluded ? type.getIgnoredColor(editor) : type.getColor(editor);
                return this.process(startLine1, endLine1, startLine2, endLine2, fillColor, borderColor, false);
            }

            public abstract boolean process(int var1, int var2, int var3, int var4, @Nullable Color var5, @Nullable Color var6, boolean var7);
        }
    }
}

