/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.DiffContentPanel;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideContentPanel
extends JPanel {
    @NotNull
    private final DiffSplitter mySplitter;
    @NotNull
    private final List<DiffContentPanel> myPanels;

    public TwosideContentPanel(@NotNull List<? extends JComponent> contents) {
        super(new BorderLayout());
        assert (contents.size() == 2);
        this.myPanels = ContainerUtil.map(contents, it -> new DiffContentPanel((JComponent)it));
        this.mySplitter = new DiffSplitter();
        this.mySplitter.setFirstComponent((JComponent)Side.LEFT.select(this.myPanels));
        this.mySplitter.setSecondComponent((JComponent)Side.RIGHT.select(this.myPanels));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.add((Component)((Object)this.mySplitter), "Center");
    }

    public void setTitles(@NotNull List<JComponent> titleComponents) {
        for (Side side : Side.values()) {
            DiffContentPanel panel2 = (DiffContentPanel)side.select(this.myPanels);
            JComponent title = (JComponent)side.select(titleComponents);
            panel2.setTitle(title);
        }
    }

    public void setBreadcrumbs(@NotNull Side side, @Nullable DiffBreadcrumbsPanel breadcrumbs, final @NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
        if (breadcrumbs != null) {
            final DiffContentPanel panel2 = (DiffContentPanel)side.select(this.myPanels);
            panel2.setBreadcrumbs(breadcrumbs);
            panel2.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
            settings.addListener(new TextDiffSettingsHolder.TextDiffSettings.Listener.Adapter(){

                @Override
                public void breadcrumbsPlacementChanged() {
                    panel2.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
                    TwosideContentPanel.this.repaintDivider();
                }
            }, breadcrumbs);
        }
    }

    public void setBottomAction(@Nullable AnAction value2) {
        this.mySplitter.setBottomAction(value2);
    }

    public void setTopAction(@Nullable AnAction value2) {
        this.mySplitter.setTopAction(value2);
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter) {
        this.mySplitter.setPainter(painter);
    }

    public void repaintDivider() {
        this.mySplitter.repaintDivider();
    }

    @NotNull
    public DiffSplitter getSplitter() {
        return this.mySplitter;
    }

    @NotNull
    public static TwosideContentPanel createFromHolders(@NotNull List<? extends EditorHolder> holders) {
        return new TwosideContentPanel(ContainerUtil.map(holders, holder -> holder.getComponent()));
    }
}

