/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.ThreeDiffSplitter;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.DiffContentPanel;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreesideContentPanel
extends JPanel {
    @NotNull
    private final ThreeDiffSplitter mySplitter;
    @NotNull
    private final List<DiffContentPanel> myPanels;

    public ThreesideContentPanel(@NotNull List<? extends JComponent> contents) {
        super(new BorderLayout());
        assert (contents.size() == 3);
        this.myPanels = ContainerUtil.map(contents, it -> new DiffContentPanel((JComponent)it));
        this.mySplitter = new ThreeDiffSplitter(this.myPanels);
        this.add((Component)this.mySplitter, "Center");
    }

    public void setTitles(@NotNull List<JComponent> titleComponents) {
        for (ThreeSide side : ThreeSide.values()) {
            DiffContentPanel panel2 = (DiffContentPanel)side.select(this.myPanels);
            JComponent title = (JComponent)side.select(titleComponents);
            panel2.setTitle(title);
        }
    }

    public void setBreadcrumbs(@NotNull ThreeSide side, @Nullable DiffBreadcrumbsPanel breadcrumbs, final @NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
        if (breadcrumbs != null) {
            final DiffContentPanel panel2 = (DiffContentPanel)side.select(this.myPanels);
            panel2.setBreadcrumbs(breadcrumbs);
            panel2.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
            settings.addListener(new TextDiffSettingsHolder.TextDiffSettings.Listener.Adapter(){

                @Override
                public void breadcrumbsPlacementChanged() {
                    panel2.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
                    ThreesideContentPanel.this.repaintDividers();
                }
            }, breadcrumbs);
        }
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter, @NotNull Side side) {
        this.mySplitter.setPainter(painter, side);
    }

    public void repaintDividers() {
        this.repaintDivider(Side.LEFT);
        this.repaintDivider(Side.RIGHT);
    }

    public void repaintDivider(@NotNull Side side) {
        this.mySplitter.repaintDivider(side);
    }

    public static class Holders
    extends ThreesideContentPanel {
        @Nullable
        private final EditorEx myBaseEditor;

        public Holders(@NotNull List<? extends EditorHolder> holders) {
            super(ContainerUtil.map(holders, holder -> holder.getComponent()));
            EditorHolder baseHolder = (EditorHolder)ThreeSide.BASE.select(holders);
            this.myBaseEditor = baseHolder instanceof TextEditorHolder ? ((TextEditorHolder)baseHolder).getEditor() : null;
        }

        @Override
        public void repaintDivider(@NotNull Side side) {
            if (side == Side.RIGHT && this.myBaseEditor != null) {
                this.myBaseEditor.getScrollPane().getVerticalScrollBar().repaint();
            }
            super.repaintDivider(side);
        }
    }
}

