/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.breadcrumbs.SimpleDiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.OnesideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.pom.Navigatable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnesideTextDiffViewer
extends OnesideDiffViewer<TextEditorHolder> {
    @NotNull
    private final List<? extends EditorEx> myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());

    public OnesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request2) {
        super(context, request2, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        DiffUtil.installLineConvertor(this.getEditor(), this.getContent());
        if (this.getProject() != null) {
            this.myContentPanel.setBreadcrumbs(new SimpleDiffBreadcrumbsPanel(this.getEditor(), (Disposable)this), this.getTextSettings());
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected TextEditorHolder createEditorHolder(@NotNull EditorHolderFactory<TextEditorHolder> factory2) {
        TextEditorHolder holder = super.createEditorHolder(factory2);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        if (forceReadOnly[0]) {
            holder.getEditor().setViewer(true);
        }
        return holder;
    }

    @Override
    @Nullable
    protected JComponent createTitle() {
        List<JComponent> textTitles = DiffUtil.createTextTitles(this.myRequest, Arrays.asList(this.getEditor(), this.getEditor()));
        return (JComponent)this.getSide().select(textTitles);
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        return TextDiffViewerUtil.getTextSettings(this.myContext);
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        return TextDiffViewerUtil.createEditorPopupActions();
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors(), this.myPanel);
    }

    protected void destroyEditorListeners() {
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        return Collections.singletonList(this.getEditor());
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        return this.myEditableEditors;
    }

    @NotNull
    public EditorEx getEditor() {
        return ((TextEditorHolder)this.getEditorHolder()).getEditor();
    }

    @NotNull
    public DocumentContent getContent() {
        return (DocumentContent)super.getContent();
    }

    protected void scrollToLine(int line) {
        DiffUtil.scrollEditor(this.getEditor(), line, false);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getContent().getNavigatable(LineCol.fromCaret((Editor)this.getEditor()));
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return OnesideDiffViewer.canShowRequest(context, request2, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getEditor();
        }
        return super.getData(dataId);
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            return OnesideTextDiffViewer.this.getEditors();
        }

        @Override
        protected void disableSyncScroll(boolean value2) {
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            Side side = (Side)this.myScrollToLine.first;
            if (side != OnesideTextDiffViewer.this.getSide()) {
                return false;
            }
            OnesideTextDiffViewer.this.scrollToLine((Integer)this.myScrollToLine.second);
            return true;
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            if (editor != OnesideTextDiffViewer.this.getEditor()) {
                return null;
            }
            return OnesideTextDiffViewer.this.getContent().getNavigatable(new LineCol(line));
        }
    }
}

