/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.util.breadcrumbs.BreadcrumbsPlacement;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.InvisibleWrapper;
import com.intellij.ui.components.panels.Wrapper;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffContentPanel
extends JPanel {
    @Nullable
    private DiffBreadcrumbsPanel myBreadcrumbs;
    private final Wrapper myTitle = new Wrapper();
    private final Wrapper myTopBreadcrumbs = new InvisibleWrapper();
    private final Wrapper myBottomBreadcrumbs = new InvisibleWrapper();

    DiffContentPanel(@NotNull JComponent content2) {
        MigLayout mgr = new MigLayout(new LC().flowY().fill().hideMode(3).insets("0").gridGapY("0"));
        this.setLayout((LayoutManager)mgr);
        this.add((Component)this.myTitle, new CC().growX().minWidth("0").gapY("0", String.valueOf(DiffUtil.TITLE_GAP)));
        this.add((Component)this.myTopBreadcrumbs, new CC().growX().minWidth("0"));
        this.add((Component)content2, new CC().grow().push());
        this.add((Component)this.myBottomBreadcrumbs, new CC().growX().minWidth("0"));
    }

    public void setTitle(@Nullable JComponent titles) {
        this.myTitle.setContent(titles);
    }

    public void setBreadcrumbs(@Nullable DiffBreadcrumbsPanel breadcrumbs) {
        if (breadcrumbs != null) {
            this.myBreadcrumbs = breadcrumbs;
        }
    }

    public void updateBreadcrumbsPlacement(@NotNull BreadcrumbsPlacement placement) {
        if (this.myBreadcrumbs == null) {
            return;
        }
        this.myTopBreadcrumbs.setContent((JComponent)(placement == BreadcrumbsPlacement.TOP ? this.myBreadcrumbs : null));
        this.myBottomBreadcrumbs.setContent((JComponent)(placement == BreadcrumbsPlacement.BOTTOM ? this.myBreadcrumbs : null));
        this.myBreadcrumbs.setCrumbsShown(placement != BreadcrumbsPlacement.HIDDEN);
        this.validate();
        this.repaint();
    }
}

