/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.breadcrumbs.BreadcrumbsPanel;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffBreadcrumbsPanel
extends BreadcrumbsPanel {
    private boolean myCrumbsShown;

    public DiffBreadcrumbsPanel(@NotNull Editor editor, @NotNull Disposable disposable2) {
        super(editor);
        Disposer.register((Disposable)disposable2, (Disposable)this);
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                DiffBreadcrumbsPanel.this.updateVisibility();
            }
        });
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateVisibility());
    }

    public void setCrumbsShown(boolean value2) {
        this.myCrumbsShown = value2;
        this.updateVisibility();
    }

    private void updateVisibility() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            boolean hasCollectors = this.updateCollectors(this.myCrumbsShown);
            if (hasCollectors != this.isVisible()) {
                this.setVisible(hasCollectors);
                this.revalidate();
                this.repaint();
            }
            this.queueUpdate();
        }, (ModalityState)ModalityState.stateForComponent((Component)this));
    }

    protected abstract boolean updateCollectors(boolean var1);

    @Nullable
    protected FileBreadcrumbsCollector findCollector(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(file2);
        if (viewProvider == null) {
            return null;
        }
        if (!ContainerUtil.exists((Iterable)viewProvider.getLanguages(), lang -> BreadcrumbsUtilEx.isBreadcrumbsShownFor(lang) && BreadcrumbsUtil.getInfoProvider((Language)lang) != null)) {
            return null;
        }
        return DiffBreadcrumbsPanel.findCollectorFor(this.myProject, file2, this);
    }

    @Override
    protected int getLeftOffset() {
        if (((EditorEx)this.myEditor).getVerticalScrollbarOrientation() == 0) {
            return 0;
        }
        return super.getLeftOffset();
    }
}

