/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.openapi.diff.DiffBundle;
import org.jetbrains.annotations.NotNull;

public enum HighlightPolicy {
    BY_LINE("option.highlighting.policy.lines"),
    BY_WORD("option.highlighting.policy.words"),
    BY_WORD_SPLIT("option.highlighting.policy.split"),
    BY_CHAR("option.highlighting.policy.symbols"),
    DO_NOT_HIGHLIGHT("option.highlighting.policy.none");

    @NotNull
    private final String myTextKey;

    private HighlightPolicy(String textKey) {
        this.myTextKey = textKey;
    }

    @NotNull
    public String getText() {
        return DiffBundle.message((String)this.myTextKey, (Object[])new Object[0]);
    }

    public boolean isShouldCompare() {
        return this != DO_NOT_HIGHLIGHT;
    }

    public boolean isFineFragments() {
        return this.getFragmentsPolicy() != InnerFragmentsPolicy.NONE;
    }

    public boolean isShouldSquash() {
        return this != BY_WORD_SPLIT;
    }

    @NotNull
    public InnerFragmentsPolicy getFragmentsPolicy() {
        switch (this) {
            case BY_WORD: 
            case BY_WORD_SPLIT: {
                return InnerFragmentsPolicy.WORDS;
            }
            case BY_CHAR: {
                return InnerFragmentsPolicy.CHARS;
            }
            case BY_LINE: 
            case DO_NOT_HIGHLIGHT: {
                return InnerFragmentsPolicy.NONE;
            }
        }
        throw new IllegalArgumentException(this.name());
    }
}

