/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelBase
extends JPanel
implements DataProvider {
    @Nullable
    protected final Project myProject;
    @NotNull
    private final DataProvider myDataProvider;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    private final List<JComponent> myPersistentNotifications = new ArrayList<JComponent>();
    @NotNull
    private final List<JComponent> myNotifications = new ArrayList<JComponent>();
    @NotNull
    protected final JPanel myContentPanel;
    @NotNull
    protected final Wrapper myNotificationsPanel;
    @NotNull
    private final Wrapper myNorthPanel;
    @NotNull
    private final Wrapper mySouthPanel;
    @NotNull
    protected final CardLayout myCardLayout;
    @NotNull
    protected String myCurrentCard;

    public DiffPanelBase(@Nullable Project project, @NotNull DataProvider provider, @NotNull DiffContext context) {
        super(new BorderLayout());
        this.myProject = project;
        this.myDataProvider = provider;
        this.myContext = context;
        this.myCardLayout = new CardLayout();
        this.myContentPanel = new JPanel(this.myCardLayout);
        this.myNotificationsPanel = new Wrapper();
        this.myNorthPanel = new Wrapper();
        this.mySouthPanel = new Wrapper();
        this.add((Component)this.myContentPanel, "Center");
        this.add((Component)this.myNorthPanel, "North");
        this.add((Component)this.mySouthPanel, "South");
    }

    public void setTopPanel(@Nullable JComponent component2) {
        this.myNorthPanel.setContent(component2);
    }

    public void setBottomPanel(@Nullable JComponent component2) {
        this.mySouthPanel.setContent(component2);
    }

    protected void setCurrentCard(@NotNull String card) {
        this.setCurrentCard(card, true);
    }

    protected void setCurrentCard(@NotNull String card, boolean keepFocus) {
        Runnable task2 = () -> {
            this.myCardLayout.show(this.myContentPanel, card);
            this.myCurrentCard = card;
            UIUtil.layoutRecursively((Component)this.myContentPanel);
            this.myContentPanel.repaint();
        };
        if (keepFocus) {
            DiffUtil.runPreservingFocus((FocusableContext)this.myContext, task2);
        } else {
            task2.run();
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        return this.myDataProvider.getData(dataId);
    }

    public void setPersistentNotifications(@NotNull List<? extends JComponent> components) {
        this.myPersistentNotifications.clear();
        this.myPersistentNotifications.addAll(components);
        this.updateNotifications();
    }

    public void resetNotifications() {
        this.myNotifications.clear();
        this.updateNotifications();
    }

    public void addNotification(@NotNull JComponent notification) {
        this.myNotifications.add(notification);
        this.updateNotifications();
    }

    private void updateNotifications() {
        List notifications = ContainerUtil.concat(this.myPersistentNotifications, this.myNotifications);
        this.myNotificationsPanel.setContent(DiffUtil.createStackedComponents(notifications, DiffUtil.TITLE_GAP));
        this.validate();
        this.repaint();
    }
}

