/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSyncScrollable
implements SyncScrollSupport.SyncScrollable {
    private static final Logger LOG = Logger.getInstance(BaseSyncScrollable.class);

    protected abstract void processHelper(@NotNull ScrollHelper var1);

    @Override
    public int transfer(@NotNull Side baseSide, int line) {
        Range range2 = this.getRange(baseSide, line);
        return BaseSyncScrollable.transferLine(line, range2);
    }

    @Override
    @NotNull
    public Range getRange(@NotNull Side baseSide, int line) {
        if (line < 0) {
            LOG.error("Invalid line number: " + line);
            return BaseSyncScrollable.idRange(line);
        }
        ScrollHelper helper = new ScrollHelper(baseSide, line);
        this.processHelper(helper);
        int master1 = helper.getMaster1();
        int master2 = helper.getMaster2();
        int slave1 = helper.getSlave1();
        int slave2 = helper.getSlave2();
        return new Range(master1, master2, slave1, slave2);
    }

    public static int transferLine(int line, @NotNull Range range2) {
        if (range2.start1 == line) {
            return range2.start2;
        }
        if (range2.end1 == line) {
            return range2.end2;
        }
        if (range2.end1 < line) {
            return line - range2.end1 + range2.end2;
        }
        return Math.min(range2.start2 + (line - range2.start1), range2.end2);
    }

    @NotNull
    public static Range idRange(int line) {
        return new Range(line, line + 1, line, line + 1);
    }

    protected static class ScrollHelper {
        @NotNull
        private final Side mySide;
        private final int myLine;
        private int myLeft1 = 0;
        private int myLeft2 = 0;
        private int myRight1 = 0;
        private int myRight2 = 0;

        public ScrollHelper(@NotNull Side side, int line) {
            this.mySide = side;
            this.myLine = line;
        }

        public boolean process(int left, int right) {
            this.myLeft1 = this.myLeft2;
            this.myRight1 = this.myRight2;
            this.myLeft2 = left;
            this.myRight2 = right;
            return this.myLine > this.mySide.select(left, right);
        }

        public int getMaster1() {
            return this.mySide.select(this.myLeft1, this.myRight1);
        }

        public int getMaster2() {
            return this.mySide.select(this.myLeft2, this.myRight2);
        }

        public int getSlave1() {
            return this.mySide.select(this.myRight1, this.myLeft1);
        }

        public int getSlave2() {
            return this.mySide.select(this.myRight2, this.myLeft2);
        }
    }
}

