/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final SimpleThreesideDiffViewer myViewer;
    @Nullable
    private final MergeInnerDifferences myInnerFragments;
    private final int[] myLineStarts = new int[3];
    private final int[] myLineEnds = new int[3];
    private boolean myIsValid = true;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @Nullable MergeInnerDifferences innerFragments, @NotNull SimpleThreesideDiffViewer viewer) {
        super(conflictType);
        this.myViewer = viewer;
        this.myInnerFragments = innerFragments;
        for (ThreeSide side : ThreeSide.values()) {
            this.myLineStarts[side.getIndex()] = fragment.getStartLine(side);
            this.myLineEnds[side.getIndex()] = fragment.getEndLine(side);
        }
        this.reinstallHighlighters();
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
        this.destroyOperations();
        this.installOperations();
    }

    @Override
    protected void installOperations() {
        this.myOperations.add(this.createAcceptOperation(ThreeSide.LEFT, ThreeSide.BASE));
        this.myOperations.add(this.createAcceptOperation(ThreeSide.RIGHT, ThreeSide.BASE));
        this.myOperations.add(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.LEFT));
        this.myOperations.add(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.RIGHT));
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        return side.select(this.myLineStarts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        return side.select(this.myLineEnds);
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        return false;
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        return this.myViewer.getEditor(side);
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void markInvalid() {
        this.myIsValid = false;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        this.myLineStarts[sideIndex] = newRange.startLine;
        this.myLineEnds[sideIndex] = newRange.endLine;
        return newRange.damaged;
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull ThreeSide sourceSide, @NotNull ThreeSide modifiedSide) {
        EditorEx editor = this.myViewer.getEditor(sourceSide);
        int offset = DiffGutterOperation.lineToOffset(editor, this.getStartLine(sourceSide));
        return new DiffGutterOperation.Simple(editor, offset, () -> {
            boolean isChanged;
            boolean isOtherEditable = this.myViewer.isEditable(modifiedSide);
            if (!isOtherEditable) {
                return null;
            }
            boolean bl = isChanged = sourceSide != ThreeSide.BASE && this.isChange(sourceSide) || modifiedSide != ThreeSide.BASE && this.isChange(modifiedSide);
            if (!isChanged) {
                return null;
            }
            String text = DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
            Side arrowDirection = Side.fromLeft((sourceSide == ThreeSide.LEFT || modifiedSide == ThreeSide.RIGHT ? 1 : 0) != 0);
            Icon icon2 = DiffUtil.getArrowIcon(arrowDirection);
            return this.createIconRenderer(sourceSide, modifiedSide, text, icon2, () -> this.myViewer.replaceChange(this, sourceSide, modifiedSide));
        });
    }

    private GutterIconRenderer createIconRenderer(@NotNull ThreeSide sourceSide, final @NotNull ThreeSide modifiedSide, @NotNull String tooltipText, @NotNull Icon icon2, final @NotNull Runnable perform2) {
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (!SimpleThreesideDiffChange.this.isValid()) {
                    return;
                }
                Project project = SimpleThreesideDiffChange.this.myViewer.getProject();
                DocumentEx document = SimpleThreesideDiffChange.this.myViewer.getEditor(modifiedSide).getDocument();
                DiffUtil.executeWriteCommand(document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), perform2);
            }
        };
    }
}

