/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffModel;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffViewer
extends TwosideTextDiffViewer {
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final SimpleDiffModel myModel = new SimpleDiffModel(this);
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper = new MyInitialScrollHelper();
    @NotNull
    private final ModifierProvider myModifierProvider;
    @NotNull
    protected final TwosideTextDiffProvider myTextDiffProvider;

    public SimpleDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        super(context, (ContentDiffRequest)request2);
        this.mySyncScrollable = new MySyncScrollable();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.getEditors(), (Disposable)this);
        this.myModifierProvider = new ModifierProvider();
        this.myTextDiffProvider = DiffUtil.createTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
        for (Side side : Side.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side), this.myFoldingModel, side.getIndex());
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter());
        this.myModifierProvider.init();
    }

    @Override
    protected void onDispose() {
        this.myModel.clear();
        this.myFoldingModel.destroy();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        return group;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new ReplaceSelectedChangesAction(Side.LEFT));
        group.add((AnAction)new AppendSelectedChangesAction(Side.LEFT));
        group.add((AnAction)new ReplaceSelectedChangesAction(Side.RIGHT));
        group.add((AnAction)new AppendSelectedChangesAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        return group;
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        return new SimpleDiffChangeUi(this, change);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        return TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        try {
            return this.computeDifferences(indicator);
        }
        catch (DiffTooBigException e) {
            return this.applyNotification(DiffNotifications.createDiffTooBig());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return this.applyNotification(DiffNotifications.createError());
        }
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        boolean isContentsEqual;
        indicator.checkCanceled();
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
        List<LineFragment> lineFragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
        boolean bl = isContentsEqual = (lineFragments == null || lineFragments.isEmpty()) && StringUtil.equals((CharSequence)texts[0], (CharSequence)texts[1]);
        if (lineFragments == null) {
            return this.apply(null, isContentsEqual);
        }
        ArrayList<SimpleDiffChange> changes = new ArrayList<SimpleDiffChange>();
        for (LineFragment fragment : lineFragments) {
            changes.add(new SimpleDiffChange(changes.size(), fragment));
        }
        return this.apply(changes, isContentsEqual);
    }

    @NotNull
    protected Runnable apply(@Nullable List<SimpleDiffChange> changes, boolean isContentsEqual) {
        List nonSkipped = changes != null ? ContainerUtil.filter(changes, it -> !it.isSkipped()) : null;
        FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(nonSkipped, this.getFoldingModelSettings());
        return () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            if (isContentsEqual) {
                boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(this.getContents());
                boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(this.getContents());
                this.myPanel.addNotification(DiffNotifications.createEqualContents(equalCharsets, equalSeparators));
            }
            this.myModel.setChanges(ContainerUtil.notNullize((List)changes), isContentsEqual);
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDivider();
            this.myStatusPanel.update();
        };
    }

    @NotNull
    protected Runnable applyNotification(@Nullable JComponent notification) {
        return () -> {
            this.clearDiffPresentation();
            this.myFoldingModel.destroy();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
    }

    private void clearDiffPresentation() {
        this.myModel.clear();
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.myContentPanel.repaintDivider();
        this.myStatusPanel.update();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        super.onBeforeDocumentChange(e);
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        Side side = Side.fromValue((List)documents, (Object)e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        this.myModel.handleBeforeDocumentChange(side, e);
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        SimpleDiffChange targetChange = scrollToPolicy.select(this.getNonSkippedDiffChanges());
        if (targetChange == null) {
            targetChange = scrollToPolicy.select(this.getDiffChanges());
        }
        if (targetChange == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    private void doScrollToChange(@NotNull SimpleDiffChange change, boolean animated) {
        int line1 = change.getStartLine(Side.LEFT);
        int line2 = change.getStartLine(Side.RIGHT);
        int endLine1 = change.getEndLine(Side.LEFT);
        int endLine2 = change.getEndLine(Side.RIGHT);
        DiffUtil.moveCaret(this.getEditor1(), line1);
        DiffUtil.moveCaret(this.getEditor2(), line2);
        this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), line1, endLine1, line2, endLine2, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator();
        int line = context.contextMatchCheck((Iterator)changedLinesIterator);
        if (line == -1) {
            AllLinesIterator allLinesIterator = new AllLinesIterator(this.getEditor(Side.RIGHT).getDocument());
            line = context.contextMatchCheck((Iterator)allLinesIterator);
        }
        if (line == -1) {
            return false;
        }
        this.scrollToLine(Side.RIGHT, line);
        return true;
    }

    @NotNull
    public List<SimpleDiffChange> getDiffChanges() {
        return this.myModel.getChanges();
    }

    @NotNull
    private List<SimpleDiffChange> getNonSkippedDiffChanges() {
        return ContainerUtil.filter(this.myModel.getChanges(), it -> !it.isSkipped());
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        return this.mySyncScrollable;
    }

    @Override
    @NotNull
    protected StatusPanel getStatusPanel() {
        return this.myStatusPanel;
    }

    @NotNull
    public KeyboardModifierListener getModifierProvider() {
        return this.myModifierProvider;
    }

    @Override
    @NotNull
    public SyncScrollSupport.TwosideSyncScrollSupport getSyncScrollSupport() {
        return super.getSyncScrollSupport();
    }

    protected boolean isEditable(@NotNull Side side) {
        return DiffUtil.isEditable(this.getEditor(side));
    }

    boolean isDiffForLocalChanges() {
        boolean isLastWithLocal = (Boolean)DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL.get((UserDataHolder)this.myContext, (Object)false);
        return isLastWithLocal && !this.isEditable(Side.LEFT) && this.isEditable(Side.RIGHT);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return TwosideTextDiffViewer.canShowRequest(context, request2);
    }

    protected boolean isSomeChangeSelected(@NotNull Side side) {
        if (this.getDiffChanges().isEmpty()) {
            return false;
        }
        EditorEx editor = this.getEditor(side);
        return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists(this.getDiffChanges(), change -> SimpleDiffViewer.isChangeSelected(change, lines, side))));
    }

    @NotNull
    protected List<SimpleDiffChange> getSelectedChanges(@NotNull Side side) {
        EditorEx editor = this.getEditor(side);
        BitSet lines = DiffUtil.getSelectedLines(editor);
        return ContainerUtil.filter(this.getDiffChanges(), change -> SimpleDiffViewer.isChangeSelected(change, lines, side));
    }

    private static boolean isChangeSelected(SimpleDiffChange change, @NotNull BitSet lines, @NotNull Side side) {
        int line1 = change.getStartLine(side);
        int line2 = change.getEndLine(side);
        return DiffUtil.isSelectedByLine(lines, line1, line2);
    }

    @Nullable
    protected SimpleDiffChange getSelectedChange(@NotNull Side side) {
        int caretLine = this.getEditor((Side)side).getCaretModel().getLogicalPosition().line;
        for (SimpleDiffChange change : this.getDiffChanges()) {
            int line2;
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    public void replaceChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (!change.isValid()) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myModel.destroyChange(change);
    }

    public void appendChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (!change.isValid()) {
            return;
        }
        if (change.getStartLine(sourceSide) == change.getEndLine(sourceSide)) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getEndLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myModel.destroyChange(change);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        SimpleDiffChange change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getSelectedChange(this.getCurrentSide())) != null) {
            return new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide()));
        }
        return super.getData(dataId);
    }

    private class MyInitialScrollHelper
    extends TwosideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return SimpleDiffViewer.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable = new FoldingModelSupport.MyPaintable(this, 0, 1);

        MyFoldingModel(@Nullable Project project, @NotNull List<? extends EditorEx> editors, @NotNull Disposable disposable2) {
            super(project, editors.toArray(new EditorEx[0]), disposable2);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<SimpleDiffChange> changes, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            this.myPaintable.paintOnDivider(gg, divider);
        }
    }

    public class ModifierProvider
    extends KeyboardModifierListener {
        public void init() {
            this.init(SimpleDiffViewer.this.myPanel, (Disposable)SimpleDiffViewer.this);
        }

        @Override
        public void onModifiersChanged() {
            SimpleDiffViewer.this.myModel.updateGutterActions(false);
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (SimpleDiffViewer.this.myTextDiffProvider.isHighlightingDisabled()) {
                return DiffBundle.message((String)"diff.highlighting.disabled.text", (Object[])new Object[0]);
            }
            List<SimpleDiffChange> allChanges = SimpleDiffViewer.this.myModel.getAllChanges();
            return DiffUtil.getStatusText(allChanges.size(), ContainerUtil.count(allChanges, it -> it.isExcluded()), SimpleDiffViewer.this.myModel.isContentsEqual());
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        @DirtyUI
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, SimpleDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(SimpleDiffViewer.this.getEditor1()));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), SimpleDiffViewer.this.getEditor1(), SimpleDiffViewer.this.getEditor2(), this);
            SimpleDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider);
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.getDiffChanges()) {
                if (handler2.processExcludable(diffChange.getStartLine(Side.LEFT), diffChange.getEndLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT), diffChange.getEndLine(Side.RIGHT), SimpleDiffViewer.this.getEditor1(), diffChange.getDiffType(), diffChange.isExcluded())) continue;
                return;
            }
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return SimpleDiffViewer.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        @NotNull
        public Range getRange(@NotNull Side baseSide, int line) {
            if (SimpleDiffViewer.this.getDiffChanges().isEmpty()) {
                return MySyncScrollable.idRange(line);
            }
            return super.getRange(baseSide, line);
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.getDiffChanges()) {
                if (!helper.process(diffChange.getStartLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(Side.LEFT), diffChange.getEndLine(Side.RIGHT))) continue;
                return;
            }
            helper.process(DiffUtil.getLineCount(SimpleDiffViewer.this.getEditor1().getDocument()), DiffUtil.getLineCount(SimpleDiffViewer.this.getEditor2().getDocument()));
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        private int myIndex = 0;

        private ChangedLinesIterator() {
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < SimpleDiffViewer.this.getDiffChanges().size();
        }

        @Override
        public void loadNextBlock() {
            SimpleDiffChange change = SimpleDiffViewer.this.getDiffChanges().get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getStartLine(Side.RIGHT);
            int line2 = change.getEndLine(Side.RIGHT);
            DocumentEx document = SimpleDiffViewer.this.getEditor(Side.RIGHT).getDocument();
            for (int i2 = line1; i2 < line2; ++i2) {
                int offset1 = document.getLineStartOffset(i2);
                int offset2 = document.getLineEndOffset(i2);
                CharSequence text = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i2, text);
            }
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(SimpleDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            SimpleDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide) {
            super(focusedSide.other());
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            return this.isBothEditable() ? DiffBundle.message((String)"action.presentation.diff.append.to.the.side.text", (Object[])new Object[]{this.myModifiedSide.getIndex()}) : DiffBundle.message((String)"action.presentation.diff.append.text", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            return DiffUtil.getArrowDownIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.appendChange(change, this.myModifiedSide.other());
            }
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide) {
            super(focusedSide.other());
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (this.myModifiedSide == Side.RIGHT && SimpleDiffViewer.this.isDiffForLocalChanges()) {
                return DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            return DiffUtil.getArrowIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends SelectedChangesActionBase {
        @NotNull
        protected final Side myModifiedSide;

        ApplySelectedChangesActionBase(Side modifiedSide) {
            this.myModifiedSide = modifiedSide;
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return false;
            }
            return !this.isBothEditable() || side == this.myModifiedSide.other();
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return;
            }
            String title = DiffBundle.message((String)"message.use.selected.changes.command", (Object[])new Object[]{e.getPresentation().getText()});
            DiffUtil.executeWriteCommand(SimpleDiffViewer.this.getEditor(this.myModifiedSide).getDocument(), e.getProject(), title, () -> this.apply(changes));
        }

        protected boolean isBothEditable() {
            return SimpleDiffViewer.this.isEditable(Side.LEFT) && SimpleDiffViewer.this.isEditable(Side.RIGHT);
        }

        protected abstract void apply(@NotNull List<SimpleDiffChange> var1);
    }

    protected abstract class SelectedChangesActionBase
    extends DumbAwareAction {
        protected SelectedChangesActionBase() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), (Object)editor);
            if (side == null || !this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setText(this.getText(side));
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SimpleDiffViewer.this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), (Object)editor);
            if (side == null) {
                return;
            }
            List<SimpleDiffChange> selectedChanges = SimpleDiffViewer.this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, side, ContainerUtil.reverse(selectedChanges));
        }

        protected abstract boolean isVisible(@NotNull Side var1);

        @Nls
        @NotNull
        protected abstract String getText(@NotNull Side var1);

        @Nullable
        protected abstract Icon getIcon(@NotNull Side var1);

        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull Side var2, @NotNull List<SimpleDiffChange> var3);
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(SimpleDiffViewer.this.getContext(), SimpleDiffViewer.this.getEditableEditors());
        }

        @Override
        protected void doApply(boolean readOnly) {
            super.doApply(readOnly);
            SimpleDiffViewer.this.myModel.updateGutterActions(true);
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<SimpleDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<SimpleDiffChange> getChanges() {
            return SimpleDiffViewer.this.getNonSkippedDiffChanges();
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            return SimpleDiffViewer.this.getCurrentEditor();
        }

        @Override
        protected int getStartLine(@NotNull SimpleDiffChange change) {
            return change.getStartLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull SimpleDiffChange change) {
            return change.getEndLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull SimpleDiffChange change) {
            SimpleDiffViewer.this.doScrollToChange(change, true);
        }
    }
}

