/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnifiedEditorRangeHighlighter {
    @NotNull
    private final List<Element> myPieces = new ArrayList<Element>();

    UnifiedEditorRangeHighlighter(@Nullable Project project, @NotNull Document document1, @NotNull Document document2, @NotNull List<HighlightRange> ranges) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model1 = (MarkupModelEx)DocumentMarkupModel.forDocument(document1, project, false);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document2, project, false);
        this.init(model1, model2, ranges);
    }

    private void init(@Nullable MarkupModelEx model1, @Nullable MarkupModelEx model2, @NotNull List<HighlightRange> ranges) {
        for (HighlightRange range2 : ranges) {
            if (range2.getSide().isLeft()) {
                if (model1 == null) continue;
                this.processRange(model1, range2);
                continue;
            }
            if (model2 == null) continue;
            this.processRange(model2, range2);
        }
    }

    private void processRange(@NotNull MarkupModelEx model, @NotNull HighlightRange range2) {
        TextRange base = range2.getBase();
        TextRange changed2 = range2.getChanged();
        int changedLength = changed2.getEndOffset() - changed2.getStartOffset();
        model.processRangeHighlightersOverlappingWith(changed2.getStartOffset(), changed2.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            int relativeStart = Math.max(marker.getStartOffset() - changed2.getStartOffset(), 0);
            int relativeEnd = Math.min(marker.getEndOffset() - changed2.getStartOffset(), changedLength);
            int newStart = base.getStartOffset() + relativeStart;
            int newEnd = base.getStartOffset() + relativeEnd;
            if (newEnd - newStart <= 0) {
                return true;
            }
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        }));
    }

    public static void erase(@Nullable Project project, @NotNull Document document) {
        MarkupModel model = DocumentMarkupModel.forDocument(document, project, true);
        model.removeAllHighlighters();
    }

    public void apply(@Nullable Project project, @NotNull Document document) {
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        for (Element piece : this.myPieces) {
            RangeHighlighterEx delegate = piece.getDelegate();
            if (!delegate.isValid()) continue;
            model.addRangeHighlighterAndChangeAttributes(delegate.getTextAttributesKey(), piece.getStart(), piece.getEnd(), delegate.getLayer(), delegate.getTargetArea(), false, (Consumer<? super RangeHighlighterEx>)((Consumer)ex -> ex.copyFrom(delegate)));
        }
    }

    private static class Element {
        @NotNull
        private final RangeHighlighterEx myDelegate;
        private final int myStart;
        private final int myEnd;

        Element(@NotNull RangeHighlighterEx delegate, int start2, int end) {
            this.myDelegate = delegate;
            this.myStart = start2;
            this.myEnd = end;
        }

        @NotNull
        public RangeHighlighterEx getDelegate() {
            return this.myDelegate;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }
    }
}

