/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleOnesideDiffViewer;
import com.intellij.openapi.diff.DiffBundle;
import org.jetbrains.annotations.NotNull;

public class UnifiedDiffTool
implements FrameDiffTool {
    public static final UnifiedDiffTool INSTANCE = new UnifiedDiffTool();

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (SimpleOnesideDiffViewer.canShowRequest(context, request2)) {
            return new SimpleOnesideDiffViewer(context, request2);
        }
        if (UnifiedDiffViewer.canShowRequest(context, request2)) {
            return new UnifiedDiffViewer(context, request2);
        }
        throw new IllegalArgumentException(request2.toString());
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return SimpleOnesideDiffViewer.canShowRequest(context, request2) || UnifiedDiffViewer.canShowRequest(context, request2);
    }

    @NotNull
    public String getName() {
        return DiffBundle.message((String)"unified.viewer", (Object[])new Object[0]);
    }
}

