/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffChangeUi;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffModel {
    @NotNull
    private final UnifiedDiffViewer myViewer;
    @Nullable
    private ChangedBlockData myData = null;
    @NotNull
    private ThreeState myIsContentsEqual = ThreeState.UNSURE;
    @NotNull
    private final List<UnifiedDiffChangeUi> myPresentations = new ArrayList<UnifiedDiffChangeUi>();
    @NotNull
    private final List<RangeMarker> myGuardedRangeBlocks = new ArrayList<RangeMarker>();

    public UnifiedDiffModel(@NotNull UnifiedDiffViewer viewer) {
        this.myViewer = viewer;
    }

    public boolean isValid() {
        return this.myData != null;
    }

    @NotNull
    public ThreeState isContentsEqual() {
        return this.myIsContentsEqual;
    }

    @Nullable
    public ChangedBlockData getData() {
        return this.myData;
    }

    @Nullable
    public List<UnifiedDiffChange> getDiffChanges() {
        return this.myData != null ? this.myData.getDiffChanges() : null;
    }

    @Nullable
    public LineNumberConvertor getLineNumberConvertor(@NotNull Side side) {
        return this.myData != null ? this.myData.getLineNumberConvertor(side) : null;
    }

    public void setChanges(@NotNull List<UnifiedDiffChange> changes, boolean isContentsEqual, @NotNull List<RangeMarker> guardedBlocks, @NotNull LineNumberConvertor convertor1, @NotNull LineNumberConvertor convertor2, @NotNull List<HighlightRange> ranges) {
        assert (this.myPresentations.isEmpty() && this.myGuardedRangeBlocks.isEmpty() && this.myData == null);
        for (UnifiedDiffChange change : changes) {
            UnifiedDiffChangeUi changeUi = this.myViewer.createUi(change);
            changeUi.installHighlighter();
            this.myPresentations.add(changeUi);
        }
        this.myGuardedRangeBlocks.addAll(guardedBlocks);
        this.myData = new ChangedBlockData(changes, convertor1, convertor2, ranges);
        this.myIsContentsEqual = ThreeState.fromBoolean((boolean)isContentsEqual);
    }

    public void clear() {
        for (UnifiedDiffChangeUi changeUi : this.myPresentations) {
            changeUi.destroyHighlighter();
        }
        this.myPresentations.clear();
        DocumentEx document = this.myViewer.getEditor().getDocument();
        for (RangeMarker block : this.myGuardedRangeBlocks) {
            document.removeGuardedBlock(block);
        }
        this.myGuardedRangeBlocks.clear();
        this.myData = null;
        this.myIsContentsEqual = ThreeState.UNSURE;
    }

    public void updateGutterActions() {
        for (UnifiedDiffChangeUi changeUi : this.myPresentations) {
            changeUi.updateGutterActions();
        }
    }

    public static class ChangedBlockData {
        @NotNull
        private final List<UnifiedDiffChange> myDiffChanges;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor1;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor2;
        @NotNull
        private final List<HighlightRange> myRanges;

        ChangedBlockData(@NotNull List<UnifiedDiffChange> diffChanges, @NotNull LineNumberConvertor lineNumberConvertor1, @NotNull LineNumberConvertor lineNumberConvertor2, @NotNull List<HighlightRange> ranges) {
            this.myDiffChanges = diffChanges;
            this.myLineNumberConvertor1 = lineNumberConvertor1;
            this.myLineNumberConvertor2 = lineNumberConvertor2;
            this.myRanges = ranges;
        }

        @NotNull
        public List<UnifiedDiffChange> getDiffChanges() {
            return this.myDiffChanges;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor(@NotNull Side side) {
            return (LineNumberConvertor)side.select((Object)this.myLineNumberConvertor1, (Object)this.myLineNumberConvertor2);
        }

        @NotNull
        public List<HighlightRange> getRanges() {
            return this.myRanges;
        }
    }
}

