/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import org.jetbrains.annotations.NotNull;

public class UnifiedDiffChange {
    private int myLine1;
    private int myLine2;
    @NotNull
    private final LineRange myDeletedRange;
    @NotNull
    private final LineRange myInsertedRange;
    @NotNull
    private final LineFragment myLineFragment;
    private final boolean myIsExcluded;
    private final boolean myIsSkipped;

    public UnifiedDiffChange(int blockStart, int insertedStart, int blockEnd, @NotNull LineFragment lineFragment) {
        this(blockStart, insertedStart, blockEnd, lineFragment, false, false);
    }

    public UnifiedDiffChange(int blockStart, int insertedStart, int blockEnd, @NotNull LineFragment lineFragment, boolean isExcluded, boolean isSkipped) {
        this.myLine1 = blockStart;
        this.myLine2 = blockEnd;
        this.myDeletedRange = new LineRange(blockStart, insertedStart);
        this.myInsertedRange = new LineRange(insertedStart, blockEnd);
        this.myLineFragment = lineFragment;
        this.myIsExcluded = isExcluded;
        this.myIsSkipped = isSkipped;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    @NotNull
    public LineFragment getLineFragment() {
        return this.myLineFragment;
    }

    @NotNull
    public LineRange getDeletedRange() {
        return this.myDeletedRange;
    }

    @NotNull
    public LineRange getInsertedRange() {
        return this.myInsertedRange;
    }

    public boolean isExcluded() {
        return this.myIsExcluded;
    }

    public boolean isSkipped() {
        return this.myIsSkipped;
    }

    public void processChange(int oldLine1, int oldLine2, int shift) {
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(this.myLine1, this.myLine2, oldLine1, oldLine2, shift);
        this.myLine1 = newRange.startLine;
        this.myLine2 = newRange.endLine;
    }
}

