/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.CommonBundle;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content2) {
        if (content2 instanceof EmptyContent) {
            return true;
        }
        if (content2 instanceof DocumentContent) {
            return true;
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            return !(file2 instanceof VirtualFileWithoutContent);
        }
        if (content2 instanceof DirectoryContent) {
            return ((DirectoryContent)content2).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@Nullable Project project, @NotNull DiffContent content2, @NotNull FileNameInfo fileName) throws IOException {
        if (content2 instanceof EmptyContent) {
            return new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], fileName));
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalInputFile(file2);
            }
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(file2, fileName));
        }
        if (content2 instanceof DocumentContent) {
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(project, (DocumentContent)content2, fileName));
        }
        if (content2 instanceof DirectoryContent) {
            VirtualFile file3 = ((DirectoryContent)content2).getFile();
            if (file3.isInLocalFileSystem()) {
                return new LocalInputFile(file3);
            }
            throw new IllegalArgumentException(content2.toString());
        }
        throw new IllegalArgumentException(content2.toString());
    }

    @NotNull
    private static File createTempFile(@Nullable Project project, @NotNull DocumentContent content2, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bom;
        FileDocumentManager.getInstance().saveDocument(content2.getDocument());
        LineSeparator separator = content2.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        Charset charset = ExternalDiffToolUtil.getContentCharset(project, content2);
        Boolean hasBom = content2.hasBom();
        if (hasBom == null) {
            hasBom = CharsetToolkit.getMandatoryBom((Charset)charset) != null;
        }
        String contentData = content2.getDocument().getText();
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        byte[] byArray = bom = hasBom != false ? CharsetToolkit.getPossibleBom((Charset)charset) : null;
        if (bom != null) {
            bytes = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes);
        }
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file2, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bytes = file2.contentsToByteArray();
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static Charset getContentCharset(@Nullable Project project, @NotNull DocumentContent content2) {
        Charset charset = content2.getCharset();
        if (charset != null) {
            return charset;
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        return e.getDefaultCharset();
    }

    @NotNull
    private static OutputFile createOutputFile(@Nullable Project project, @NotNull DiffContent content2, @NotNull FileNameInfo fileName) throws IOException {
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalOutputFile(file2);
            }
            File tempFile = ExternalDiffToolUtil.createTempFile(file2, fileName);
            return new NonLocalOutputFile(file2, tempFile);
        }
        if (content2 instanceof DocumentContent) {
            DocumentContent documentContent = (DocumentContent)content2;
            File tempFile = ExternalDiffToolUtil.createTempFile(project, documentContent, fileName);
            Charset charset = ExternalDiffToolUtil.getContentCharset(project, documentContent);
            return new DocumentOutputFile(documentContent.getDocument(), charset, tempFile);
        }
        throw new IllegalArgumentException(content2.toString());
    }

    @NotNull
    private static File createFile(byte @NotNull [] bytes, @NotNull FileNameInfo fileName) throws IOException {
        File tempFile = FileUtil.createTempFile((String)(fileName.prefix + "_"), (String)("_" + fileName.name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        return tempFile;
    }

    public static void execute(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<InputFile> files2 = new ArrayList<InputFile>();
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            DiffContent content2 = contents.get(i2);
            FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
            files2.add(ExternalDiffToolUtil.createFile(project, content2, fileName));
        }
        HashMap<String, String> patterns = new HashMap<String, String>();
        if (files2.size() == 2) {
            patterns.put("%1", ((InputFile)files2.get(0)).getPath());
            patterns.put("%2", ((InputFile)files2.get(1)).getPath());
            patterns.put("%3", "");
        } else {
            patterns.put("%1", ((InputFile)files2.get(0)).getPath());
            patterns.put("%2", ((InputFile)files2.get(2)).getPath());
            patterns.put("%3", ((InputFile)files2.get(1)).getPath());
        }
        ExternalDiffToolUtil.execute(settings.getDiffExePath(), settings.getDiffParameters(), patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMerge(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request2) throws IOException, ExecutionException {
        boolean success = false;
        try {
            success = ExternalDiffToolUtil.tryExecuteMerge(project, settings, request2);
            request2.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
        }
        catch (Throwable throwable) {
            request2.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryExecuteMerge(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request2) throws IOException, ExecutionException {
        boolean success;
        InputFile outputFile = null;
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        try {
            DiffContent outputContent = request2.getOutputContent();
            List contents = request2.getContents();
            List titles = request2.getContentTitles();
            String windowTitle = request2.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            for (int i2 = 0; i2 < contents.size(); ++i2) {
                DiffContent content2 = (DiffContent)contents.get(i2);
                FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
                inputFiles.add(ExternalDiffToolUtil.createFile(project, content2, fileName));
            }
            outputFile = ExternalDiffToolUtil.createOutputFile(project, outputContent, FileNameInfo.createMergeResult(outputContent, windowTitle));
            HashMap<String, String> patterns = new HashMap<String, String>();
            patterns.put("%1", ((InputFile)inputFiles.get(0)).getPath());
            patterns.put("%2", ((InputFile)inputFiles.get(2)).getPath());
            patterns.put("%3", ((InputFile)inputFiles.get(1)).getPath());
            patterns.put("%4", outputFile.getPath());
            final Process process2 = ExternalDiffToolUtil.execute(settings.getMergeExePath(), settings.getMergeParameters(), patterns);
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().run((Task)new Task.Modal(project, DiffBundle.message((String)"waiting.for.external.tool", (Object[])new Object[0]), true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        final Semaphore semaphore = new Semaphore(0);
                        Thread waiter = new Thread("external process waiter"){

                            @Override
                            public void run() {
                                try {
                                    resultRef.set((Object)(process2.waitFor() == 0 ? 1 : 0));
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        waiter.start();
                        try {
                            do {
                                indicator.checkCanceled();
                            } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            waiter.interrupt();
                        }
                    }
                });
                success = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project, DiffBundle.message((String)"launching.external.tool", (Object[])new Object[0]), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        indicator.setIndeterminate(true);
                        TimeoutUtil.sleep((long)1000L);
                    }
                });
                boolean bl = success = Messages.showYesNoDialog((Project)project, (String)DiffBundle.message((String)"press.mark.as.resolve", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.in.external.tool", (Object[])new Object[0]), (String)DiffBundle.message((String)"mark.as.resolved", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.revert", (Object[])new Object[0]), null) == 0;
            }
            if (success) {
                outputFile.apply();
            }
        }
        finally {
            if (outputFile != null) {
                outputFile.cleanup();
            }
            for (InputFile file2 : inputFiles) {
                file2.cleanup();
            }
        }
        return success;
    }

    @NotNull
    private static Process execute(@NotNull String exePath, @NotNull String parametersTemplate, @NotNull Map<String, String> patterns) throws ExecutionException {
        List parameters2 = ParametersListUtil.parse((String)parametersTemplate, (boolean)true);
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            from.add(entry.getKey());
            to.add(entry.getValue());
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String parameter : parameters2) {
            String arg = StringUtil.replace((String)parameter, from, to);
            if (StringUtil.isEmptyOrSpaces((String)arg)) continue;
            args.add(arg);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exePath);
        generalCommandLine.addParameters(args);
        return generalCommandLine.createProcess();
    }

    private static class FileNameInfo {
        @NotNull
        public final String prefix;
        @NotNull
        public final String name;

        FileNameInfo(@NotNull @NonNls String prefix, @NotNull @NonNls String name) {
            this.prefix = prefix;
            this.name = name;
        }

        @NotNull
        public static FileNameInfo create(@NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle, int index) {
            if (contents.size() == 2) {
                Side side = Side.fromIndex((int)index);
                DiffContent content2 = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"before", (Object)"after");
                String name = FileNameInfo.getFileName(content2, title, windowTitle);
                return new FileNameInfo(prefix, name);
            }
            if (contents.size() == 3) {
                ThreeSide side = ThreeSide.fromIndex((int)index);
                DiffContent content3 = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"left", (Object)"base", (Object)"right");
                String name = FileNameInfo.getFileName(content3, title, windowTitle);
                return new FileNameInfo(prefix, name);
            }
            throw new IllegalArgumentException(String.valueOf(contents.size()));
        }

        @NotNull
        public static FileNameInfo createMergeResult(@NotNull DiffContent content2, @Nullable String windowTitle) {
            String name = FileNameInfo.getFileName(content2, null, windowTitle);
            return new FileNameInfo("merge_result", name);
        }

        @NotNull
        private static String getFileName(@NotNull DiffContent content2, @Nullable String title, @Nullable String windowTitle) {
            String ext;
            if (content2 instanceof EmptyContent) {
                return "no_content.tmp";
            }
            String fileName = (String)content2.getUserData(DiffUserDataKeysEx.FILE_NAME);
            if (fileName == null && content2 instanceof DocumentContent) {
                VirtualFile highlightFile = ((DocumentContent)content2).getHighlightFile();
                String string = fileName = highlightFile != null ? highlightFile.getName() : null;
            }
            if (fileName == null && content2 instanceof FileContent) {
                fileName = ((FileContent)content2).getFile().getName();
            }
            if (!StringUtil.isEmptyOrSpaces((String)fileName)) {
                return fileName;
            }
            FileType fileType = content2.getContentType();
            String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
            if (StringUtil.isEmptyOrSpaces((String)ext)) {
                ext = "tmp";
            }
            String name = "";
            if (title != null && windowTitle != null) {
                name = title + "_" + windowTitle;
            } else if (title != null || windowTitle != null) {
                String string2 = name = title != null ? title : windowTitle;
            }
            if (name.length() > 50) {
                name = name.substring(0, 50);
            }
            return PathUtil.suggestFileName((String)(name + "." + ext), (boolean)true, (boolean)false);
        }
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        TempInputFile(@NotNull File localFile) {
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myLocalFile.getPath();
        }

        @Override
        public void cleanup() {
            FileUtil.delete((File)this.myLocalFile);
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        LocalInputFile(@NotNull VirtualFile file2) {
            this.myFile = file2;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myFile.getPath();
        }

        @Override
        public void cleanup() {
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        DocumentOutputFile(@NotNull Document document, @NotNull Charset charset, @NotNull File localFile) {
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset;
        }

        @Override
        public void apply() throws IOException {
            String content2 = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)content2));
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        NonLocalOutputFile(@NotNull VirtualFile file2, @NotNull File localFile) {
            super(localFile);
            this.myFile = file2;
        }

        @Override
        public void apply() throws IOException {
            FileUtil.copy((File)this.myLocalFile, (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myFile});
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        LocalOutputFile(@NotNull VirtualFile file2) {
            super(file2);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }
}

