/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.TransferableFileEditorStateSupport;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideBinaryDiffViewer
extends TwosideDiffViewer<BinaryEditorHolder> {
    @NotNull
    private final TransferableFileEditorStateSupport myTransferableStateSupport;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private ComparisonData myComparisonData = ComparisonData.UNKNOWN;

    public TwosideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        super(context, (ContentDiffRequest)request2, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myStatusPanel = new MyStatusPanel();
        new MyFocusOppositePaneAction().install(this.myPanel);
        this.myContentPanel.setTopAction((AnAction)new MyAcceptSideAction(Side.LEFT));
        this.myContentPanel.setBottomAction((AnAction)new MyAcceptSideAction(Side.RIGHT));
        this.myTransferableStateSupport = new TransferableFileEditorStateSupport(DiffUtil.getDiffSettings(context), this.getEditorHolders(), (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myTransferableStateSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myTransferableStateSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyAcceptSideAction(Side.LEFT));
        group.add((AnAction)new MyAcceptSideAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.add(this.myTransferableStateSupport.createToggleAction());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        try {
            indicator.checkCanceled();
            List contents = this.myRequest.getContents();
            if (!(contents.get(0) instanceof FileContent) || !(contents.get(1) instanceof FileContent)) {
                return this.applyNotification(ComparisonData.UNKNOWN);
            }
            VirtualFile file1 = ((FileContent)contents.get(0)).getFile();
            VirtualFile file2 = ((FileContent)contents.get(1)).getFile();
            ComparisonData comparisonData = (ComparisonData)ReadAction.nonBlocking(() -> {
                if (!file1.isValid() || !file2.isValid()) {
                    return ComparisonData.ERROR;
                }
                long length1 = file1.getLength();
                long length2 = file2.getLength();
                try {
                    boolean contentsEquals;
                    if (length1 > 0L && length2 > 0L && length1 != length2) {
                        contentsEquals = false;
                    } else {
                        if (FileUtilRt.isTooLarge((long)length1) || FileUtilRt.isTooLarge((long)length2)) {
                            return new ComparisonData(ThreeState.UNSURE, () -> DiffBundle.message((String)"error.files.too.large.to.compare.text", (Object[])new Object[0]));
                        }
                        contentsEquals = DiffUtil.compareStreams((ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> DiffUtil.getFileInputStream(file1)), (ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> DiffUtil.getFileInputStream(file2)));
                    }
                    return new ComparisonData(ThreeState.fromBoolean((boolean)contentsEquals), () -> contentsEquals ? DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]) : null);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    return ComparisonData.ERROR;
                }
            }).wrapProgress(indicator).executeSynchronously();
            return this.applyNotification(comparisonData);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return this.applyNotification(ComparisonData.ERROR);
        }
    }

    @NotNull
    private Runnable applyNotification(@NotNull ComparisonData comparisonData) {
        return () -> {
            this.clearDiffPresentation();
            this.myComparisonData = comparisonData;
            if (this.myComparisonData.notification.get() != null) {
                this.myPanel.addNotification(DiffNotifications.createNotification((String)this.myComparisonData.notification.get()));
            }
            this.myStatusPanel.update();
        };
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getCurrentEditor() {
        return ((BinaryEditorHolder)this.getCurrentEditorHolder()).getEditor();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        return this.myStatusPanel;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return TwosideDiffViewer.canShowRequest(context, request2, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }

    private static class ComparisonData {
        public static final ComparisonData UNKNOWN = new ComparisonData(ThreeState.UNSURE, (NullableComputable<String>)((NullableComputable)() -> null));
        public static final ComparisonData ERROR = new ComparisonData(ThreeState.UNSURE, (NullableComputable<String>)((NullableComputable)() -> DiffBundle.message((String)"diff.cant.calculate.diff", (Object[])new Object[0])));
        @NotNull
        public final ThreeState isContentsEqual;
        @NotNull
        public final NullableComputable<String> notification;

        private ComparisonData(@NotNull ThreeState isContentsEqual, @NotNull NullableComputable<String> notification) {
            this.isContentsEqual = isContentsEqual;
            this.notification = notification;
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            TwosideBinaryDiffViewer.this.setCurrentSide(TwosideBinaryDiffViewer.this.getCurrentSide().other());
            DiffUtil.requestFocus(TwosideBinaryDiffViewer.this.getProject(), TwosideBinaryDiffViewer.this.getPreferredFocusedComponent());
        }
    }

    private class MyAcceptSideAction
    extends DumbAwareAction {
        @NotNull
        private final Side myBaseSide;

        MyAcceptSideAction(Side baseSide) {
            this.myBaseSide = baseSide;
            this.getTemplatePresentation().setText(DiffBundle.message((String)"copy.content.to.side", (Object[])new Object[]{baseSide.other().getIndex()}));
            this.getTemplatePresentation().setIcon((Icon)baseSide.select((Object)AllIcons.Vcs.Arrow_right, (Object)AllIcons.Vcs.Arrow_left));
            this.setShortcutSet(ActionManager.getInstance().getAction((String)baseSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        public void update(@NotNull AnActionEvent e) {
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            boolean enabled = baseFile != null && targetFile != null && targetFile.isWritable();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            assert (baseFile != null && targetFile != null);
            try {
                WriteAction.run(() -> targetFile.setBinaryContent(baseFile.contentsToByteArray()));
            }
            catch (IOException err) {
                LOG.warn((Throwable)err);
                Messages.showErrorDialog((Project)TwosideBinaryDiffViewer.this.getProject(), (String)err.getMessage(), (String)DiffBundle.message((String)"can.t.copy.file", (Object[])new Object[0]));
            }
        }

        @Nullable
        private VirtualFile getContentFile(@NotNull Side side) {
            DiffContent content2 = (DiffContent)side.select(TwosideBinaryDiffViewer.this.myRequest.getContents());
            VirtualFile file2 = content2 instanceof FileContent ? ((FileContent)content2).getFile() : null;
            return file2 != null && file2.isValid() ? file2 : null;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (((TwosideBinaryDiffViewer)TwosideBinaryDiffViewer.this).myComparisonData.isContentsEqual == ThreeState.UNSURE) {
                return null;
            }
            if (((TwosideBinaryDiffViewer)TwosideBinaryDiffViewer.this).myComparisonData.isContentsEqual == ThreeState.YES) {
                return DiffBundle.message((String)"binary.diff.contents.are.identical.message.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"binary.diff.contents.are.different.message.text", (Object[])new Object[0]);
        }
    }
}

