/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.TransferableFileEditorStateSupport;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.EmptyRunnable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ThreesideBinaryDiffViewer
extends ThreesideDiffViewer<BinaryEditorHolder> {
    @NotNull
    private final TransferableFileEditorStateSupport myTransferableStateSupport;

    public ThreesideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        super(context, (ContentDiffRequest)request2, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myTransferableStateSupport = new TransferableFileEditorStateSupport(DiffUtil.getDiffSettings(context), this.getEditorHolders(), (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myTransferableStateSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myTransferableStateSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        DefaultActionGroup diffGroup = DefaultActionGroup.createPopupGroup(() -> DiffBundle.message((String)"group.compare.contents.text", (Object[])new Object[0]));
        diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        diffGroup.add((AnAction)Separator.create((String)DiffBundle.message((String)"group.compare.contents.text", (Object[])new Object[0])));
        diffGroup.add((AnAction)new ThreesideDiffViewer.ShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_LEFT, false));
        diffGroup.add((AnAction)new ThreesideDiffViewer.ShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_RIGHT, false));
        diffGroup.add((AnAction)new ThreesideDiffViewer.ShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, false));
        group.add((AnAction)diffGroup);
        group.add((AnAction)Separator.getInstance());
        group.add(this.myTransferableStateSupport.createToggleAction());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        return EmptyRunnable.INSTANCE;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return ThreesideDiffViewer.canShowRequest(context, request2, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }
}

