/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.OnesideBinaryDiffViewer;
import com.intellij.diff.tools.binary.ThreesideBinaryDiffViewer;
import com.intellij.diff.tools.binary.TwosideBinaryDiffViewer;
import com.intellij.openapi.diff.DiffBundle;
import org.jetbrains.annotations.NotNull;

public class BinaryDiffTool
implements FrameDiffTool {
    public static final BinaryDiffTool INSTANCE = new BinaryDiffTool();

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (OnesideBinaryDiffViewer.canShowRequest(context, request2)) {
            return new OnesideBinaryDiffViewer(context, request2);
        }
        if (TwosideBinaryDiffViewer.canShowRequest(context, request2)) {
            return new TwosideBinaryDiffViewer(context, request2);
        }
        if (ThreesideBinaryDiffViewer.canShowRequest(context, request2)) {
            return new ThreesideBinaryDiffViewer(context, request2);
        }
        throw new IllegalArgumentException(request2.toString());
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return OnesideBinaryDiffViewer.canShowRequest(context, request2) || TwosideBinaryDiffViewer.canShowRequest(context, request2) || ThreesideBinaryDiffViewer.canShowRequest(context, request2);
    }

    @NotNull
    public String getName() {
        return DiffBundle.message((String)"binary.file.viewer", (Object[])new Object[0]);
    }
}

