/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ProxySimpleDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.SimpleLineStatusTracker;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeViewer
implements MergeTool.MergeViewer {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final TextMergeRequest myMergeRequest;
    @NotNull
    private final MyThreesideViewer myViewer;
    private final Action myCancelResolveAction;
    private final Action myLeftResolveAction;
    private final Action myRightResolveAction;
    private final Action myAcceptResolveAction;

    public TextMergeViewer(@NotNull MergeContext context, @NotNull TextMergeRequest request2) {
        this.myMergeContext = context;
        this.myMergeRequest = request2;
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
        ProxySimpleDiffRequest diffRequest = new ProxySimpleDiffRequest(this.myMergeRequest.getTitle(), TextMergeViewer.getDiffContents(this.myMergeRequest), TextMergeViewer.getDiffContentTitles(this.myMergeRequest), (UserDataHolder)this.myMergeRequest);
        diffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{true, false, true});
        this.myViewer = new MyThreesideViewer(diffContext, (ContentDiffRequest)diffRequest);
        this.myCancelResolveAction = this.myViewer.getResolveAction(MergeResult.CANCEL);
        this.myLeftResolveAction = this.myViewer.getResolveAction(MergeResult.LEFT);
        this.myRightResolveAction = this.myViewer.getResolveAction(MergeResult.RIGHT);
        this.myAcceptResolveAction = this.myViewer.getResolveAction(MergeResult.RESOLVED);
    }

    @NotNull
    private static List<DiffContent> getDiffContents(@NotNull TextMergeRequest mergeRequest) {
        List contents = mergeRequest.getContents();
        DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
        DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
        DocumentContent output = mergeRequest.getOutputContent();
        return Arrays.asList(left, output, right);
    }

    @NotNull
    private static List<String> getDiffContentTitles(@NotNull TextMergeRequest mergeRequest) {
        List<String> titles = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        titles.set(ThreeSide.BASE.getIndex(), DiffBundle.message((String)"merge.version.title.merged.result", (Object[])new Object[0]));
        return titles;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myViewer.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
        FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
        components.statusPanel = init2.statusPanel;
        components.toolbarActions = init2.toolbarActions;
        components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext, this.myViewer.myContentModified);
        return components;
    }

    @Nullable
    public Action getResolveAction(@NotNull MergeResult result2) {
        switch (result2) {
            case CANCEL: {
                return this.myCancelResolveAction;
            }
            case LEFT: {
                return this.myLeftResolveAction;
            }
            case RIGHT: {
                return this.myRightResolveAction;
            }
            case RESOLVED: {
                return this.myAcceptResolveAction;
            }
        }
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public MyThreesideViewer getViewer() {
        return this.myViewer;
    }

    private static class InnerChunkData {
        @NotNull
        public final List<CharSequence> text;

        InnerChunkData(@NotNull TextMergeChange change, @NotNull List<? extends Document> documents) {
            this.text = InnerChunkData.getChunks(change, documents);
        }

        @NotNull
        private static List<CharSequence> getChunks(@NotNull TextMergeChange change, @NotNull List<? extends Document> documents) {
            return ThreeSide.map(side -> {
                int endLine;
                if (!change.isChange((ThreeSide)side) || change.isResolved((ThreeSide)side)) {
                    return null;
                }
                int startLine = change.getStartLine((ThreeSide)side);
                if (startLine == (endLine = change.getEndLine((ThreeSide)side))) {
                    return null;
                }
                return DiffUtil.getLinesContent((Document)side.select(documents), startLine, endLine);
            });
        }
    }

    public class MyThreesideViewer
    extends ThreesideTextDiffViewerEx {
        @NotNull
        private final MergeModelBase myModel;
        @NotNull
        private final ModifierProvider myModifierProvider;
        @NotNull
        private final MyInnerDiffWorker myInnerDiffWorker;
        @NotNull
        private final SimpleLineStatusTracker myLineStatusTracker;
        @NotNull
        private final TextDiffProviderBase myTextDiffProvider;
        @NotNull
        private final List<TextMergeChange> myAllMergeChanges;
        @NotNull
        private IgnorePolicy myCurrentIgnorePolicy;
        private boolean myInitialRediffStarted;
        private boolean myInitialRediffFinished;
        private boolean myContentModified;

        public MyThreesideViewer(@NotNull DiffContext context, ContentDiffRequest request2) {
            super(context, request2);
            this.myAllMergeChanges = new ArrayList<TextMergeChange>();
            this.myModel = new MyMergeModel(this.getProject(), this.getEditor().getDocument());
            this.myModifierProvider = new ModifierProvider();
            this.myInnerDiffWorker = new MyInnerDiffWorker();
            this.myLineStatusTracker = new SimpleLineStatusTracker(this.getProject(), this.getEditor().getDocument(), (Function1<? super SimpleLineStatusTracker, ? extends LineStatusMarkerRenderer>)((Function1)x$0 -> new MyLineStatusMarkerRenderer((LineStatusTrackerBase<?>)x$0)));
            this.myTextDiffProvider = new TextDiffProviderBase(this.getTextSettings(), () -> {
                this.restartMergeResolveIfNeeded();
                this.myInnerDiffWorker.onSettingsChanged();
            }, (Disposable)this, (IgnorePolicy[])ContainerUtil.ar((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES}), (HighlightPolicy[])ContainerUtil.ar((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD}));
            this.myCurrentIgnorePolicy = this.myTextDiffProvider.getIgnorePolicy();
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(false), this.myPanel);
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(true), this.myPanel);
            ProxyUndoRedoAction.register(this.getProject(), this.getEditor(), this.myContentPanel);
        }

        @Override
        protected void onInit() {
            super.onInit();
            this.myModifierProvider.init();
        }

        @Override
        protected void onDispose() {
            Disposer.dispose((Disposable)this.myModel);
            this.myLineStatusTracker.release();
            this.myInnerDiffWorker.disable();
            super.onDispose();
        }

        @Override
        @NotNull
        protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory2) {
            List<TextEditorHolder> holders = super.createEditorHolders(factory2);
            ((TextEditorHolder)ThreeSide.BASE.select(holders)).getEditor().putUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG, true);
            return holders;
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            DefaultActionGroup diffGroup = DefaultActionGroup.createPopupGroup(() -> DiffBundle.message((String)"group.compare.contents.text", (Object[])new Object[0]));
            diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
            diffGroup.add((AnAction)Separator.create((String)DiffBundle.message((String)"group.compare.contents.text", (Object[])new Object[0])));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.RIGHT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, true));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.LEFT));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.BASE));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.RIGHT));
            group.add((AnAction)diffGroup);
            group.add((AnAction)new Separator(DiffBundle.messagePointer((String)"action.Anonymous.text.apply.non.conflicting.changes", (Object[])new Object[0])));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.LEFT, DiffBundle.message((String)"action.merge.apply.non.conflicts.left.text", (Object[])new Object[0])));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.BASE, DiffBundle.message((String)"action.merge.apply.non.conflicts.all.text", (Object[])new Object[0])));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.RIGHT, DiffBundle.message((String)"action.merge.apply.non.conflicts.right.text", (Object[])new Object[0])));
            group.add((AnAction)new MagicResolvedConflictsAction());
            group.add((AnAction)Separator.getInstance());
            group.addAll(this.myTextDiffProvider.getToolbarActions());
            group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            group.add((AnAction)this.myEditorSettingsAction);
            return group;
        }

        @Override
        @NotNull
        protected List<AnAction> createEditorPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            group.add(new ApplySelectedChangesAction(Side.LEFT));
            group.add(new ApplySelectedChangesAction(Side.RIGHT));
            group.add(new ResolveSelectedChangesAction(Side.LEFT));
            group.add(new ResolveSelectedChangesAction(Side.RIGHT));
            group.add(new IgnoreSelectedChangesSideAction(Side.LEFT));
            group.add(new IgnoreSelectedChangesSideAction(Side.RIGHT));
            group.add(new ResolveSelectedConflictsAction());
            group.add(new IgnoreSelectedChangesAction());
            group.add((AnAction)Separator.getInstance());
            group.addAll(TextDiffViewerUtil.createEditorPopupActions());
            return group;
        }

        @Override
        @Nullable
        protected List<AnAction> createPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            return group;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result2) {
            String caption = MergeUtil.getResolveActionTitle(result2, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!(result2 != MergeResult.LEFT && result2 != MergeResult.RIGHT || MergeUtil.showConfirmDiscardChangesDialog(MyThreesideViewer.this.myPanel.getRootPane(), result2 == MergeResult.LEFT ? DiffBundle.message((String)"button.merge.resolve.accept.left", (Object[])new Object[0]) : DiffBundle.message((String)"button.merge.resolve.accept.right", (Object[])new Object[0]), MyThreesideViewer.this.myContentModified))) {
                        return;
                    }
                    if (result2 == MergeResult.RESOLVED && (MyThreesideViewer.this.getChangesCount() > 0 || MyThreesideViewer.this.getConflictsCount() > 0) && Messages.showConfirmationDialog((JComponent)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{MyThreesideViewer.this.getChangesCount(), MyThreesideViewer.this.getConflictsCount()}), (String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (String)DiffBundle.message((String)"apply.changes.and.mark.resolved", (Object[])new Object[0]), (String)DiffBundle.message((String)"continue.merge", (Object[])new Object[0])) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(TextMergeViewer.this, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext, MyThreesideViewer.this.myContentModified)) {
                        return;
                    }
                    MyThreesideViewer.this.destroyChangedBlocks();
                    TextMergeViewer.this.myMergeContext.finishMerge(result2);
                }
            };
        }

        private void restartMergeResolveIfNeeded() {
            if (this.isDisposed()) {
                return;
            }
            if (this.myTextDiffProvider.getIgnorePolicy().equals((Object)this.myCurrentIgnorePolicy)) {
                return;
            }
            if (!this.myInitialRediffFinished) {
                ApplicationManager.getApplication().invokeLater(() -> this.restartMergeResolveIfNeeded());
                return;
            }
            if (this.myContentModified && Messages.showYesNoDialog((Project)this.myProject, (String)DiffBundle.message((String)"changing.highlighting.requires.the.file.merge.restart", (Object[])new Object[0]), (String)DiffBundle.message((String)"update.highlighting.settings", (Object[])new Object[0]), (String)DiffBundle.message((String)"discard.changes.and.restart.merge", (Object[])new Object[0]), (String)DiffBundle.message((String)"continue.merge", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                this.getTextSettings().setIgnorePolicy(this.myCurrentIgnorePolicy);
                return;
            }
            this.myInitialRediffFinished = false;
            this.doRediff();
        }

        private boolean setInitialOutputContent() {
            Document baseDocument = ((DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents())).getDocument();
            Document outputDocument = TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument();
            return DiffUtil.executeWriteCommand(outputDocument, this.getProject(), DiffBundle.message((String)"message.init.merge.content.command", (Object[])new Object[0]), () -> {
                outputDocument.setText(baseDocument.getCharsSequence());
                DiffUtil.putNonundoableOperation(this.getProject(), outputDocument);
                if (this.getTextSettings().isEnableLstGutterMarkersInMerge()) {
                    this.myLineStatusTracker.setBaseRevision(baseDocument.getCharsSequence());
                    this.getEditor().getGutterComponentEx().setForceShowRightFreePaintersArea(true);
                }
            });
        }

        @Override
        public void rediff(boolean trySync) {
            if (this.myInitialRediffStarted) {
                return;
            }
            this.myInitialRediffStarted = true;
            assert (this.myAllMergeChanges.isEmpty());
            this.doRediff();
        }

        @Override
        @NotNull
        protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
            throw new UnsupportedOperationException();
        }

        private void doRediff() {
            this.myStatusPanel.setBusy(true);
            this.myInnerDiffWorker.disable();
            this.getEditor().setViewer(true);
            this.myLoadingPanel.startLoading();
            TextMergeViewer.this.myAcceptResolveAction.setEnabled(false);
            BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> {
                try {
                    return this.doPerformRediff((ProgressIndicator)indicator);
                }
                catch (ProcessCanceledException e) {
                    return () -> TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    return () -> TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }
            })), null, 300L, ApplicationManager.getApplication().isUnitTestMode());
        }

        @NotNull
        protected Runnable doPerformRediff(@NotNull ProgressIndicator indicator) {
            try {
                indicator.checkCanceled();
                IgnorePolicy ignorePolicy = this.myTextDiffProvider.getIgnorePolicy();
                List contents = TextMergeViewer.this.myMergeRequest.getContents();
                List sequences = (List)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    return ContainerUtil.map((Collection)contents, content2 -> content2.getDocument().getImmutableCharSequence());
                });
                List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsetsUtil::create);
                ComparisonManager manager = ComparisonManager.getInstance();
                List lineFragments = manager.mergeLines((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), ignorePolicy.getComparisonPolicy(), indicator);
                List conflictTypes = ContainerUtil.map((Collection)lineFragments, fragment -> DiffUtil.getLineMergeType(fragment, sequences, lineOffsets, ignorePolicy.getComparisonPolicy()));
                FoldingModelSupport.Data foldingState = this.myFoldingModel.createState((List<? extends MergeLineFragment>)lineFragments, lineOffsets, this.getFoldingModelSettings());
                return () -> this.apply(lineFragments, conflictTypes, foldingState, ignorePolicy);
            }
            catch (DiffTooBigException e) {
                return this.applyNotification(DiffNotifications.createDiffTooBig());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                return () -> {
                    this.clearDiffPresentation();
                    this.myPanel.setErrorContent();
                };
            }
        }

        private void apply(@NotNull List<? extends MergeLineFragment> fragments, @NotNull List<? extends MergeConflictType> conflictTypes, @Nullable FoldingModelSupport.Data foldingState, @NotNull IgnorePolicy ignorePolicy) {
            if (this.isDisposed()) {
                return;
            }
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            boolean success = this.setInitialOutputContent();
            if (!success) {
                fragments = Collections.emptyList();
                conflictTypes = Collections.emptyList();
                this.myPanel.addNotification(DiffNotifications.createNotification(DiffBundle.message((String)"error.cant.resolve.conflicts.in.a.read.only.file", (Object[])new Object[0])));
            }
            this.myModel.setChanges(ContainerUtil.map(fragments, f -> new LineRange(f.getStartLine(ThreeSide.BASE), f.getEndLine(ThreeSide.BASE))));
            for (int index = 0; index < fragments.size(); ++index) {
                MergeLineFragment fragment = (MergeLineFragment)fragments.get(index);
                MergeConflictType conflictType = conflictTypes.get(index);
                TextMergeChange change = new TextMergeChange(index, fragment, conflictType, TextMergeViewer.this);
                this.myAllMergeChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
            this.getEditor().setViewer(false);
            this.myLoadingPanel.stopLoading();
            TextMergeViewer.this.myAcceptResolveAction.setEnabled(true);
            this.myInnerDiffWorker.onEverythingChanged();
            this.myInitialRediffFinished = true;
            this.myContentModified = false;
            this.myCurrentIgnorePolicy = ignorePolicy;
            if (TextMergeViewer.this.myViewer.getTextSettings().isAutoApplyNonConflictedChanges() && this.hasNonConflictedChanges(ThreeSide.BASE)) {
                this.applyNonConflictedChanges(ThreeSide.BASE);
            }
        }

        @Override
        protected void destroyChangedBlocks() {
            super.destroyChangedBlocks();
            this.myInnerDiffWorker.stop();
            for (TextMergeChange change : this.myAllMergeChanges) {
                change.destroy();
            }
            this.myAllMergeChanges.clear();
            this.myModel.setChanges(Collections.emptyList());
        }

        @Override
        protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
            super.onBeforeDocumentChange(e);
            if (this.myInitialRediffFinished) {
                this.myContentModified = true;
            }
        }

        public void repaintDividers() {
            this.myContentPanel.repaintDividers();
        }

        private void onChangeResolved(@NotNull TextMergeChange change) {
            if (change.isResolved()) {
                this.onChangeRemoved(change);
            } else {
                this.onChangeAdded(change);
            }
            if (this.getChangesCount() == 0 && this.getConflictsCount() == 0) {
                LOG.assertTrue(ContainerUtil.and(this.getAllChanges(), TextMergeChange::isResolved));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    JComponent component2 = this.getEditor().getComponent();
                    RelativePoint point = new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, JBUIScale.scale((int)5)));
                    String message = DiffBundle.message((String)"merge.all.changes.processed.message.text", (Object[])new Object[0]);
                    DiffUtil.showSuccessPopup(message, point, (Disposable)this, () -> {
                        if (this.isDisposed() || this.myLoadingPanel.isLoading()) {
                            return;
                        }
                        this.destroyChangedBlocks();
                        TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                    });
                });
            }
        }

        @NotNull
        public MergeModelBase getModel() {
            return this.myModel;
        }

        @NotNull
        public List<TextMergeChange> getAllChanges() {
            return this.myAllMergeChanges;
        }

        @NotNull
        public List<TextMergeChange> getChanges() {
            return ContainerUtil.filter(this.myAllMergeChanges, mergeChange -> !mergeChange.isResolved());
        }

        @Override
        @NotNull
        protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
            return new MyDividerPaintable(side);
        }

        @NotNull
        public KeyboardModifierListener getModifierProvider() {
            return this.myModifierProvider;
        }

        @NotNull
        public EditorEx getEditor() {
            return this.getEditor(ThreeSide.BASE);
        }

        public boolean executeMergeCommand(@Nullable @Nls String commandName, boolean underBulkUpdate, @Nullable List<? extends TextMergeChange> affected, @NotNull Runnable task2) {
            this.myContentModified = true;
            TIntArrayList affectedIndexes = null;
            if (affected != null) {
                affectedIndexes = new TIntArrayList(affected.size());
                for (TextMergeChange textMergeChange : affected) {
                    affectedIndexes.add(textMergeChange.getIndex());
                }
            }
            return this.myModel.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, underBulkUpdate, affectedIndexes, task2);
        }

        public boolean executeMergeCommand(@Nullable @Nls String commandName, @Nullable List<? extends TextMergeChange> affected, @NotNull Runnable task2) {
            return this.executeMergeCommand(commandName, false, affected, task2);
        }

        public void markChangeResolved(@NotNull TextMergeChange change) {
            if (change.isResolved()) {
                return;
            }
            change.setResolved(Side.LEFT, true);
            change.setResolved(Side.RIGHT, true);
            this.onChangeResolved(change);
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void markChangeResolved(@NotNull TextMergeChange change, @NotNull Side side) {
            if (change.isResolved(side)) {
                return;
            }
            change.setResolved(side, true);
            if (change.isResolved()) {
                this.onChangeResolved(change);
            }
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void ignoreChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (!change.isConflict() || resolveChange) {
                this.markChangeResolved(change);
            } else {
                this.markChangeResolved(change, side);
            }
        }

        public void replaceChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change.isResolved(side)) {
                return;
            }
            if (!change.isChange(side)) {
                this.markChangeResolved(change);
                return;
            }
            ThreeSide sourceSide = (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            ThreeSide oppositeSide = (ThreeSide)side.select((Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
            Document sourceDocument = this.getContent(sourceSide).getDocument();
            int sourceStartLine = change.getStartLine(sourceSide);
            int sourceEndLine = change.getEndLine(sourceSide);
            List<String> newContent = DiffUtil.getLines(sourceDocument, sourceStartLine, sourceEndLine);
            if (change.isConflict()) {
                boolean append = change.isOnesideAppliedConflict();
                if (append) {
                    this.myModel.appendChange(change.getIndex(), newContent);
                } else {
                    this.myModel.replaceChange(change.getIndex(), newContent);
                }
                if (resolveChange || change.getStartLine(oppositeSide) == change.getEndLine(oppositeSide)) {
                    this.markChangeResolved(change);
                } else {
                    change.markOnesideAppliedConflict();
                    this.markChangeResolved(change, side);
                }
            } else {
                this.myModel.replaceChange(change.getIndex(), newContent);
                this.markChangeResolved(change);
            }
        }

        private boolean hasNonConflictedChanges(@NotNull ThreeSide side) {
            return ContainerUtil.exists(this.getAllChanges(), change -> !change.isConflict() && this.canResolveChangeAutomatically((TextMergeChange)change, side));
        }

        private void applyNonConflictedChanges(@NotNull ThreeSide side) {
            this.executeMergeCommand(DiffBundle.message((String)"merge.dialog.apply.non.conflicted.changes.command", (Object[])new Object[0]), true, null, () -> {
                ArrayList<TextMergeChange> allChanges = new ArrayList<TextMergeChange>(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    if (change.isConflict()) continue;
                    this.resolveChangeAutomatically(change, side);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        private boolean hasResolvableConflictedChanges() {
            return ContainerUtil.exists(this.getAllChanges(), change -> this.canResolveChangeAutomatically((TextMergeChange)change, ThreeSide.BASE));
        }

        private void applyResolvableConflictedChanges() {
            this.executeMergeCommand(DiffBundle.message((String)"message.resolve.simple.conflicts.command", (Object[])new Object[0]), true, null, () -> {
                ArrayList<TextMergeChange> allChanges = new ArrayList<TextMergeChange>(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        public boolean canResolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (change.isConflict()) {
                return side == ThreeSide.BASE && change.getType().canBeResolved() && !change.isResolved(Side.LEFT) && !change.isResolved(Side.RIGHT) && !this.isChangeRangeModified(change);
            }
            return !change.isResolved() && change.isChange(side) && !this.isChangeRangeModified(change);
        }

        private boolean isChangeRangeModified(@NotNull TextMergeChange change) {
            CharSequence resultContent;
            MergeLineFragment changeFragment = change.getFragment();
            int baseStartLine = changeFragment.getStartLine(ThreeSide.BASE);
            int baseEndLine = changeFragment.getEndLine(ThreeSide.BASE);
            DocumentContent baseDiffContent = (DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
            Document baseDocument = baseDiffContent.getDocument();
            int resultStartLine = change.getStartLine();
            int resultEndLine = change.getEndLine();
            DocumentEx resultDocument = this.getEditor().getDocument();
            CharSequence baseContent = DiffUtil.getLinesContent(baseDocument, baseStartLine, baseEndLine);
            return !StringUtil.equals((CharSequence)baseContent, (CharSequence)(resultContent = DiffUtil.getLinesContent(resultDocument, resultStartLine, resultEndLine)));
        }

        public void resolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (!this.canResolveChangeAutomatically(change, side)) {
                return;
            }
            if (change.isConflict()) {
                List texts = ThreeSide.map(it -> DiffUtil.getLinesContent(this.getEditor((ThreeSide)it).getDocument(), change.getStartLine((ThreeSide)it), change.getEndLine((ThreeSide)it)));
                CharSequence newContent = ComparisonMergeUtil.tryResolveConflict((CharSequence)texts.get(0), (CharSequence)texts.get(1), (CharSequence)texts.get(2));
                if (newContent == null) {
                    LOG.warn(String.format("Can't resolve conflicting change:\n'%s'\n'%s'\n'%s'\n", texts.get(0), texts.get(1), texts.get(2)));
                    return;
                }
                String[] newContentLines = LineTokenizer.tokenize((CharSequence)newContent, (boolean)false);
                this.myModel.replaceChange(change.getIndex(), Arrays.asList(newContentLines));
                this.markChangeResolved(change);
            } else {
                Side masterSide = (Side)side.select((Object)Side.LEFT, (Object)(change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT), (Object)Side.RIGHT);
                this.replaceChange(change, masterSide, false);
            }
        }

        private class NavigateToChangeMarkerAction
        extends DumbAwareAction {
            private final boolean myGoToNext;

            protected NavigateToChangeMarkerAction(boolean goToNext) {
                this.myGoToNext = goToNext;
                ActionUtil.copyFrom((AnAction)this, (String)(this.myGoToNext ? "VcsShowNextChangeMarker" : "VcsShowPrevChangeMarker"));
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.getTextSettings().isEnableLstGutterMarkersInMerge());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object targetRange;
                if (!MyThreesideViewer.this.myLineStatusTracker.isValid()) {
                    return;
                }
                int line = MyThreesideViewer.this.getEditor().getCaretModel().getLogicalPosition().line;
                Object r = targetRange = this.myGoToNext ? MyThreesideViewer.this.myLineStatusTracker.getNextRange(line) : MyThreesideViewer.this.myLineStatusTracker.getPrevRange(line);
                if (targetRange != null) {
                    new MyLineStatusMarkerRenderer(MyThreesideViewer.this.myLineStatusTracker).scrollAndShow(MyThreesideViewer.this.getEditor(), (Range)targetRange);
                }
            }
        }

        private class MyLineStatusMarkerRenderer
        extends LineStatusMarkerPopupRenderer {
            MyLineStatusMarkerRenderer(LineStatusTrackerBase<?> tracker) {
                super(tracker);
            }

            @Override
            @Nullable
            protected MarkupEditorFilter getEditorFilter() {
                return editor -> editor == MyThreesideViewer.this.getEditor();
            }

            @Override
            protected int getFramingBorderSize() {
                return JBUIScale.scale((int)2);
            }

            @Override
            public void scrollAndShow(@NotNull Editor editor, @NotNull Range range2) {
                if (!this.myTracker.isValid()) {
                    return;
                }
                Document document = this.myTracker.getDocument();
                int line = Math.min(range2.getType() == 3 ? range2.getLine2() : range2.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
                int[] startLines = new int[]{((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line, line, ((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line};
                for (ThreeSide side : ThreeSide.values()) {
                    DiffUtil.moveCaret(MyThreesideViewer.this.getEditor(side), side.select(startLines));
                }
                MyThreesideViewer.this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                this.showAfterScroll(editor, range2);
            }

            @Override
            @NotNull
            protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
                ArrayList<AnAction> actions = new ArrayList<AnAction>();
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new MyRollbackLineStatusRangeAction(editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction(this, editor, range2, mousePosition));
                return actions;
            }

            private class MyRollbackLineStatusRangeAction
            extends LineStatusMarkerPopupRenderer.RangeMarkerAction {
                private MyRollbackLineStatusRangeAction(@NotNull Editor editor, Range range2) {
                    super(MyLineStatusMarkerRenderer.this, editor, range2, "Vcs.RollbackChangedLines");
                }

                @Override
                protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
                    return true;
                }

                @Override
                protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
                    DiffUtil.moveCaretToLineRangeIfNeeded(editor, range2.getLine1(), range2.getLine2());
                    MyLineStatusMarkerRenderer.this.myTracker.rollbackChanges(range2);
                }
            }
        }

        public class ModifierProvider
        extends KeyboardModifierListener {
            public void init() {
                this.init(MyThreesideViewer.this.myPanel, (Disposable)TextMergeViewer.this);
            }

            @Override
            public void onModifiersChanged() {
                for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                    change.updateGutterActions(false);
                }
            }
        }

        private class MyDividerPaintable
        implements DiffDividerDrawUtil.DividerPaintable {
            @NotNull
            private final Side mySide;

            MyDividerPaintable(Side side) {
                this.mySide = side;
            }

            @Override
            public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
                ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
                ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
                for (TextMergeChange mergeChange : MyThreesideViewer.this.myAllMergeChanges) {
                    if (!mergeChange.isChange(this.mySide)) continue;
                    boolean isResolved = mergeChange.isResolved(this.mySide);
                    if (handler2.processResolvable(mergeChange.getStartLine(left), mergeChange.getEndLine(left), mergeChange.getStartLine(right), mergeChange.getEndLine(right), MyThreesideViewer.this.getEditor(), mergeChange.getDiffType(), isResolved)) continue;
                    return;
                }
            }
        }

        private class ShowDiffWithBaseAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            ShowDiffWithBaseAction(ThreeSide side) {
                this.mySide = side;
                String actionId = (String)this.mySide.select((Object)"Diff.CompareWithBase.Left", (Object)"Diff.CompareWithBase.Result", (Object)"Diff.CompareWithBase.Right");
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DiffContent baseContent = (DiffContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
                String baseTitle = (String)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContentTitles());
                DiffContent otherContent = (DiffContent)this.mySide.select(MyThreesideViewer.this.myRequest.getContents());
                String otherTitle = (String)this.mySide.select(MyThreesideViewer.this.myRequest.getContentTitles());
                SimpleDiffRequest request2 = new SimpleDiffRequest(MyThreesideViewer.this.myRequest.getTitle(), baseContent, otherContent, baseTitle, otherTitle);
                ThreeSide currentSide = MyThreesideViewer.this.getCurrentSide();
                LogicalPosition currentPosition = DiffUtil.getCaretPosition(MyThreesideViewer.this.getCurrentEditor());
                LogicalPosition resultPosition = MyThreesideViewer.this.transferPosition(currentSide, this.mySide, currentPosition);
                request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)resultPosition.line));
                DiffManager.getInstance().showDiff(MyThreesideViewer.this.myProject, (DiffRequest)request2, new DiffDialogHints(null, (Component)MyThreesideViewer.this.myPanel));
            }
        }

        public class MagicResolvedConflictsAction
        extends DumbAwareAction {
            public MagicResolvedConflictsAction() {
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.MagicResolveConflicts");
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasResolvableConflictedChanges());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                MyThreesideViewer.this.applyResolvableConflictedChanges();
            }
        }

        public class ApplyNonConflictsAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            public ApplyNonConflictsAction(@NotNull @Nls ThreeSide side, String text) {
                String id2 = (String)side.select((Object)"Diff.ApplyNonConflicts.Left", (Object)"Diff.ApplyNonConflicts", (Object)"Diff.ApplyNonConflicts.Right");
                ActionUtil.copyFrom((AnAction)this, (String)id2);
                this.mySide = side;
                this.getTemplatePresentation().setText(text);
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasNonConflictedChanges(this.mySide));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                MyThreesideViewer.this.applyNonConflictedChanges(this.mySide);
            }

            public boolean displayTextInToolbar() {
                return true;
            }

            public boolean useSmallerFontForTextInToolbar() {
                return true;
            }
        }

        private class ResolveSelectedConflictsAction
        extends ApplySelectedChangesActionBase {
            ResolveSelectedConflictsAction() {
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.ResolveConflict");
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return DiffBundle.message((String)"action.presentation.merge.resolve.automatically.text", (Object[])new Object[0]);
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return MyThreesideViewer.this.canResolveChangeAutomatically(change, ThreeSide.BASE);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    TextMergeChange change = changes.get(i2);
                    MyThreesideViewer.this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            }
        }

        private class ResolveSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            ResolveSelectedChangesAction(Side side) {
                this.mySide = side;
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return DiffBundle.message((String)"action.presentation.merge.resolve.using.side.text", (Object[])new Object[]{this.mySide.getIndex()});
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    MyThreesideViewer.this.replaceChange(changes.get(i2), this.mySide, true);
                }
            }
        }

        private class ApplySelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            ApplySelectedChangesAction(Side side) {
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return side != ThreeSide.BASE ? DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]) : this.getTemplatePresentation().getText();
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    MyThreesideViewer.this.replaceChange(changes.get(i2), this.mySide, false);
                }
            }
        }

        private class IgnoreSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            IgnoreSelectedChangesAction() {
                this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]);
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved();
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                for (TextMergeChange textMergeChange : changes) {
                    MyThreesideViewer.this.markChangeResolved(textMergeChange);
                }
            }
        }

        private class IgnoreSelectedChangesSideAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            IgnoreSelectedChangesSideAction(Side side) {
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.IgnoreLeftSide", (Object)"Diff.IgnoreRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]);
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                for (TextMergeChange textMergeChange : changes) {
                    MyThreesideViewer.this.ignoreChange(textMergeChange, this.mySide, false);
                }
            }
        }

        private abstract class ApplySelectedChangesActionBase
        extends AnAction
        implements DumbAware {
            private ApplySelectedChangesActionBase() {
            }

            public void update(@NotNull AnActionEvent e) {
                if (DiffUtil.isFromShortcut(e)) {
                    e.getPresentation().setEnabledAndVisible(true);
                    return;
                }
                Presentation presentation2 = e.getPresentation();
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (side == null) {
                    presentation2.setEnabledAndVisible(false);
                    return;
                }
                if (!this.isVisible(side)) {
                    presentation2.setEnabledAndVisible(false);
                    return;
                }
                presentation2.setText(this.getText(side));
                presentation2.setVisible(true);
                presentation2.setEnabled(this.isSomeChangeSelected(side));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (editor == null || side == null) {
                    return;
                }
                List<TextMergeChange> selectedChanges = this.getSelectedChanges(side);
                if (selectedChanges.isEmpty()) {
                    return;
                }
                String title = DiffBundle.message((String)"message.do.in.merge.command", (Object[])new Object[]{e.getPresentation().getText()});
                MyThreesideViewer.this.executeMergeCommand(title, selectedChanges.size() > 1, selectedChanges, () -> this.apply(side, selectedChanges));
            }

            private boolean isSomeChangeSelected(@NotNull ThreeSide side) {
                EditorEx editor = MyThreesideViewer.this.getEditor(side);
                return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists(MyThreesideViewer.this.getAllChanges(), change -> this.isChangeSelected((TextMergeChange)change, (BitSet)lines, side))));
            }

            @NotNull
            private List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
                EditorEx editor = MyThreesideViewer.this.getEditor(side);
                BitSet lines = DiffUtil.getSelectedLines(editor);
                return ContainerUtil.filter(MyThreesideViewer.this.getChanges(), change -> this.isChangeSelected((TextMergeChange)change, lines, side));
            }

            private boolean isChangeSelected(@NotNull TextMergeChange change, @NotNull BitSet lines, @NotNull ThreeSide side) {
                if (!this.isEnabled(change)) {
                    return false;
                }
                int line1 = change.getStartLine(side);
                int line2 = change.getEndLine(side);
                return DiffUtil.isSelectedByLine(lines, line1, line2);
            }

            @Nls
            protected abstract String getText(@NotNull ThreeSide var1);

            protected abstract boolean isVisible(@NotNull ThreeSide var1);

            protected abstract boolean isEnabled(@NotNull TextMergeChange var1);

            protected abstract void apply(@NotNull ThreeSide var1, @NotNull List<? extends TextMergeChange> var2);
        }

        private class MyMergeModel
        extends MergeModelBase<TextMergeChange.State> {
            MyMergeModel(@NotNull Project project, Document document) {
                super(project, document);
            }

            @Override
            protected void reinstallHighlighters(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                change.reinstallHighlighters();
                MyThreesideViewer.this.myInnerDiffWorker.scheduleRediff(change);
            }

            @Override
            @NotNull
            protected TextMergeChange.State storeChangeState(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                return change.storeState();
            }

            @Override
            protected void restoreChangeState(@NotNull TextMergeChange.State state) {
                super.restoreChangeState(state);
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(state.myIndex);
                boolean wasResolved = change.isResolved();
                change.restoreState(state);
                if (wasResolved != change.isResolved()) {
                    MyThreesideViewer.this.onChangeResolved(change);
                }
            }

            @Override
            @Nullable
            protected TextMergeChange.State processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
                TextMergeChange.State state = (TextMergeChange.State)super.processDocumentChange(index, oldLine1, oldLine2, shift);
                TextMergeChange mergeChange = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                if (mergeChange.getStartLine() == mergeChange.getEndLine() && mergeChange.getDiffType() == TextDiffType.DELETED && !mergeChange.isResolved()) {
                    TextMergeViewer.this.myViewer.markChangeResolved(mergeChange);
                }
                return state;
            }
        }

        private class MyInnerDiffWorker {
            @NotNull
            private final Set<TextMergeChange> myScheduled = new HashSet<TextMergeChange>();
            @NotNull
            private final Alarm myAlarm = new Alarm((Disposable)MyThreesideViewer.this);
            @Nullable
            private ProgressIndicator myProgress;
            private boolean myEnabled = false;

            private MyInnerDiffWorker() {
            }

            public void scheduleRediff(@NotNull TextMergeChange change) {
                this.scheduleRediff(Collections.singletonList(change));
            }

            public void scheduleRediff(@NotNull Collection<? extends TextMergeChange> changes) {
                if (!this.myEnabled) {
                    return;
                }
                this.putChanges(changes);
                this.schedule();
            }

            public void onSettingsChanged() {
                boolean enabled;
                boolean bl = enabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                if (this.myEnabled == enabled) {
                    return;
                }
                this.myEnabled = enabled;
                this.rebuildEverything();
            }

            public void onEverythingChanged() {
                this.myEnabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                this.rebuildEverything();
            }

            public void disable() {
                this.myEnabled = false;
                this.stop();
            }

            private void rebuildEverything() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                if (this.myEnabled) {
                    this.putChanges(MyThreesideViewer.this.myAllMergeChanges);
                    this.launchRediff(true);
                } else {
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    this.myScheduled.clear();
                    for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                        change.setInnerFragments(null);
                    }
                }
            }

            public void stop() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                this.myScheduled.clear();
                this.myAlarm.cancelAllRequests();
            }

            private void putChanges(@NotNull Collection<? extends TextMergeChange> changes) {
                for (TextMergeChange textMergeChange : changes) {
                    if (textMergeChange.isResolved()) continue;
                    this.myScheduled.add(textMergeChange);
                }
            }

            private void schedule() {
                if (this.myProgress != null) {
                    return;
                }
                if (this.myScheduled.isEmpty()) {
                    return;
                }
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.launchRediff(false), 300);
            }

            private void launchRediff(boolean trySync) {
                MyThreesideViewer.this.myStatusPanel.setBusy(true);
                ArrayList<TextMergeChange> scheduled = new ArrayList<TextMergeChange>(this.myScheduled);
                this.myScheduled.clear();
                List documents = ThreeSide.map(side -> MyThreesideViewer.this.getEditor((ThreeSide)side).getDocument());
                List data2 = ContainerUtil.map(scheduled, change -> new InnerChunkData((TextMergeChange)change, documents));
                int waitMillis = trySync ? 300 : 0;
                ProgressIndicator progress2 = BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> this.performRediff((List<? extends TextMergeChange>)scheduled, data2, (ProgressIndicator)indicator)), null, waitMillis, false);
                if (progress2.isRunning()) {
                    this.myProgress = progress2;
                }
            }

            @NotNull
            private Runnable performRediff(@NotNull List<? extends TextMergeChange> scheduled, @NotNull List<? extends InnerChunkData> data2, @NotNull ProgressIndicator indicator) {
                ComparisonPolicy comparisonPolicy = MyThreesideViewer.this.myTextDiffProvider.getIgnorePolicy().getComparisonPolicy();
                ArrayList<MergeInnerDifferences> result2 = new ArrayList<MergeInnerDifferences>(data2.size());
                for (InnerChunkData innerChunkData : data2) {
                    result2.add(DiffUtil.compareThreesideInner(innerChunkData.text, comparisonPolicy, indicator));
                }
                return () -> {
                    if (!this.myEnabled || indicator.isCanceled()) {
                        return;
                    }
                    this.myProgress = null;
                    for (int i2 = 0; i2 < scheduled.size(); ++i2) {
                        TextMergeChange change = (TextMergeChange)scheduled.get(i2);
                        if (this.myScheduled.contains(change)) continue;
                        change.setInnerFragments((MergeInnerDifferences)result2.get(i2));
                    }
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    if (!this.myScheduled.isEmpty()) {
                        this.launchRediff(false);
                    }
                };
            }
        }
    }
}

