/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final TextMergeViewer myMergeViewer;
    @NotNull
    private final TextMergeViewer.MyThreesideViewer myViewer;
    private final int myIndex;
    @NotNull
    private final MergeLineFragment myFragment;
    private final boolean[] myResolved = new boolean[2];
    private boolean myOnesideAppliedConflict;
    @Nullable
    private MergeInnerDifferences myInnerFragments;

    public TextMergeChange(int index, @NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @NotNull TextMergeViewer viewer) {
        super(conflictType);
        this.myMergeViewer = viewer;
        this.myViewer = viewer.getViewer();
        this.myIndex = index;
        this.myFragment = fragment;
        this.reinstallHighlighters();
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyOperations();
        this.installOperations();
        this.myViewer.repaintDividers();
    }

    public int getIndex() {
        return this.myIndex;
    }

    void setResolved(@NotNull Side side, boolean value2) {
        this.myResolved[side.getIndex()] = value2;
        if (this.isResolved()) {
            this.destroyInnerHighlighters();
        } else {
            DocumentEx document = this.myViewer.getEditor((ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT)).getDocument();
            for (RangeHighlighter highlighter : this.myInnerHighlighters) {
                if (!document.equals(highlighter.getDocument())) continue;
                highlighter.dispose();
            }
        }
    }

    public boolean isResolved() {
        return this.myResolved[0] && this.myResolved[1];
    }

    public boolean isResolved(@NotNull Side side) {
        return side.select(this.myResolved);
    }

    public boolean isOnesideAppliedConflict() {
        return this.myOnesideAppliedConflict;
    }

    public void markOnesideAppliedConflict() {
        this.myOnesideAppliedConflict = true;
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        switch (side) {
            case LEFT: {
                return this.isResolved(Side.LEFT);
            }
            case BASE: {
                return this.isResolved();
            }
            case RIGHT: {
                return this.isResolved(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    public int getStartLine() {
        return this.myViewer.getModel().getLineStart(this.myIndex);
    }

    public int getEndLine() {
        return this.myViewer.getModel().getLineEnd(this.myIndex);
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == ThreeSide.BASE) {
            return this.getStartLine();
        }
        return this.myFragment.getStartLine(side);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == ThreeSide.BASE) {
            return this.getEndLine();
        }
        return this.myFragment.getEndLine(side);
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        return this.myViewer.getEditor(side);
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    @NotNull
    public MergeLineFragment getFragment() {
        return this.myFragment;
    }

    public void setInnerFragments(@Nullable MergeInnerDifferences innerFragments) {
        if (this.myInnerFragments == null && innerFragments == null) {
            return;
        }
        this.myInnerFragments = innerFragments;
        this.reinstallHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    @Override
    protected void installOperations() {
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createResolveOperation());
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.LEFT, OperationType.APPLY));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.LEFT, OperationType.IGNORE));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.RIGHT, OperationType.APPLY));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.RIGHT, OperationType.IGNORE));
    }

    @Nullable
    private DiffGutterOperation createOperation(@NotNull ThreeSide side, @NotNull DiffGutterOperation.ModifiersRendererBuilder builder2) {
        if (this.isResolved(side)) {
            return null;
        }
        EditorEx editor = this.myViewer.getEditor(side);
        int offset = DiffGutterOperation.lineToOffset(editor, this.getStartLine(side));
        return new DiffGutterOperation.WithModifiers(editor, offset, this.myViewer.getModifierProvider(), builder2);
    }

    @Nullable
    private DiffGutterOperation createResolveOperation() {
        return this.createOperation(ThreeSide.BASE, (ctrlPressed, shiftPressed, altPressed) -> this.createResolveRenderer());
    }

    @Nullable
    private DiffGutterOperation createAcceptOperation(@NotNull Side versionSide, @NotNull OperationType type) {
        ThreeSide side = (ThreeSide)versionSide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        return this.createOperation(side, (ctrlPressed, shiftPressed, altPressed) -> {
            if (!this.isChange(versionSide)) {
                return null;
            }
            if (type == OperationType.APPLY) {
                return this.createApplyRenderer(versionSide, ctrlPressed);
            }
            return this.createIgnoreRenderer(versionSide, ctrlPressed);
        });
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side, boolean modifier) {
        if (this.isResolved(side)) {
            return null;
        }
        Icon icon2 = this.isOnesideAppliedConflict() ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]), icon2, this.isConflict(), () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.replaceChange(this, side, modifier)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer(@NotNull Side side, boolean modifier) {
        if (this.isResolved(side)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]), AllIcons.Diff.Remove, this.isConflict(), () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.ignoreChange(this, side, modifier)));
    }

    @Nullable
    private GutterIconRenderer createResolveRenderer() {
        if (!this.isConflict() || !this.myViewer.canResolveChangeAutomatically(this, ThreeSide.BASE)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.resolve.text", (Object[])new Object[0]), AllIcons.Diff.MagicResolve, false, () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.resolve.conflict.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.resolveChangeAutomatically(this, ThreeSide.BASE)));
    }

    @NotNull
    private static GutterIconRenderer createIconRenderer(@NotNull String text, @NotNull Icon icon2, boolean ctrlClickVisible, final @NotNull Runnable perform2) {
        String appendix = ctrlClickVisible ? DiffBundle.message((String)"tooltip.merge.ctrl.click.to.resolve.conflict", (Object[])new Object[0]) : null;
        String tooltipText = DiffUtil.createTooltipText(text, appendix);
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                perform2.run();
            }
        };
    }

    @NotNull
    State storeState() {
        return new State(this.myIndex, this.getStartLine(), this.getEndLine(), this.myResolved[0], this.myResolved[1], this.myOnesideAppliedConflict);
    }

    void restoreState(@NotNull State state) {
        this.myResolved[0] = state.myResolved1;
        this.myResolved[1] = state.myResolved2;
        this.myOnesideAppliedConflict = state.myOnesideAppliedConflict;
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved1;
        private final boolean myResolved2;
        private final boolean myOnesideAppliedConflict;

        public State(int index, int startLine, int endLine, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict) {
            super(index, startLine, endLine);
            this.myResolved1 = resolved1;
            this.myResolved2 = resolved2;
            this.myOnesideAppliedConflict = onesideAppliedConflict;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }
}

