/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2) {
        this(project, document, file2, null);
    }

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        super(project, document);
        this.myFile = file2;
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)this.myHighlightFile, (Object)this.myFile);
    }

    @Nullable
    public LineSeparator getLineSeparator() {
        String s = LoadTextUtil.detectLineSeparator(this.myFile, true);
        if (s == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @Nullable
    public Charset getCharset() {
        return this.myFile.getCharset();
    }

    @Nullable
    public Boolean hasBom() {
        return this.myFile.getBOM() != null;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public FileType getContentType() {
        return this.myFile.getFileType();
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }
}

