/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends DiffContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileType myType;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileContentImpl(@Nullable Project project, @NotNull VirtualFile file2) {
        this(project, file2, file2);
    }

    public FileContentImpl(@Nullable Project project, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        assert (!file2.isDirectory());
        this.myFile = file2;
        this.myProject = project;
        this.myType = file2.getFileType();
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (!DiffUtil.canNavigateToFile(this.myProject, this.myHighlightFile)) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myHighlightFile);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public FileType getContentType() {
        return this.myType;
    }

    @NotNull
    public String getFilePath() {
        return this.myFile.getPath();
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }
}

